/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.nls;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageUtil {
    private ResourceBundle messages;
    private static final StackFinder finder = AccessController.doPrivileged(new PrivilegedAction<StackFinder>(){

        @Override
        public StackFinder run() {
            return new StackFinder();
        }
    });

    private MessageUtil(ResourceBundle b) {
        this.messages = b;
    }

    public String getMessage(String key, Object ... inserts) {
        String message;
        try {
            message = this.messages.getString(key);
            if (inserts != null && inserts.length > 0) {
                message = MessageFormat.format(message, inserts);
            }
        }
        catch (MissingResourceException e) {
            message = key;
        }
        return message;
    }

    public static MessageUtil createMessageUtil(Class<?> context, String baseName) {
        return MessageUtil.createMessageUtil(FrameworkUtil.getBundle(context), baseName);
    }

    public static MessageUtil createMessageUtil(String baseName) {
        Class<?>[] stack;
        for (Class<?> clazz : stack = finder.getClassContext()) {
            if (clazz == MessageUtil.class) continue;
            return MessageUtil.createMessageUtil(clazz, baseName);
        }
        throw new MissingResourceException(org.apache.aries.util.internal.MessageUtil.getMessage("UTIL0014E", baseName), baseName, null);
    }

    public static MessageUtil createMessageUtil(final Bundle b, String baseName) {
        ResourceBundle rb = b == null ? ResourceBundle.getBundle(baseName) : ResourceBundle.getBundle(baseName, new ResourceBundle.Control(){

            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                ResourceBundle result;
                final String bundleName = this.toBundleName(baseName, locale);
                if (FORMAT_PROPERTIES.contains(format)) {
                    final String resourceName = this.toResourceName(bundleName, "properties");
                    URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                        @Override
                        public URL run() {
                            URL url = b.getResource(resourceName);
                            if (url == null) {
                                url = b.getEntry(resourceName);
                            }
                            return url;
                        }
                    });
                    result = url != null ? new PropertyResourceBundle(url.openStream()) : null;
                } else if (FORMAT_CLASS.contains(format)) {
                    Class<? extends ListResourceBundle> clazz = AccessController.doPrivileged(new PrivilegedAction<Class<? extends ListResourceBundle>>(){

                        @Override
                        public Class<? extends ListResourceBundle> run() {
                            try {
                                return b.loadClass(bundleName);
                            }
                            catch (ClassNotFoundException e) {
                                return null;
                            }
                        }
                    });
                    result = clazz != null ? (ResourceBundle)clazz.newInstance() : null;
                } else {
                    throw new IllegalArgumentException(org.apache.aries.util.internal.MessageUtil.getMessage("UTIL0013E", format));
                }
                return result;
            }
        });
        return new MessageUtil(rb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackFinder
    extends SecurityManager {
        private StackFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

