/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.impl.ProcessorEndpoint;

public class BeanEndpoint
extends ProcessorEndpoint {
    private boolean cache;
    private boolean multiParameterArray;
    private String beanName;
    private String method;
    private BeanHolder beanHolder;

    public BeanEndpoint() {
        this.init();
    }

    public BeanEndpoint(String endpointUri, Component component, BeanProcessor processor) {
        super(endpointUri, component, (Processor)processor);
        this.init();
    }

    public BeanEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.init();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public void setBeanHolder(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    @Override
    protected String createEndpointUri() {
        return "bean:" + this.getBeanName() + (this.method != null ? "?method=" + this.method : "");
    }

    private void init() {
        this.setExchangePattern(ExchangePattern.InOut);
    }

    @Override
    protected Processor createProcessor() throws Exception {
        BeanHolder holder = this.getBeanHolder();
        if (holder == null) {
            RegistryBean registryBean = new RegistryBean(this.getCamelContext(), this.beanName);
            holder = this.cache ? registryBean.createCacheHolder() : registryBean;
        }
        BeanProcessor processor = new BeanProcessor(holder);
        if (this.method != null) {
            processor.setMethod(this.method);
        }
        processor.setMultiParameterArray(this.isMultiParameterArray());
        return processor;
    }
}

