/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerTemplate
extends ServiceSupport
implements ConsumerTemplate {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultConsumerTemplate.class);
    private final CamelContext context;
    private ConsumerCache consumerCache;
    private int maximumCacheSize;

    public DefaultConsumerTemplate(CamelContext context) {
        this.context = context;
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.consumerCache == null) {
            return 0;
        }
        return this.consumerCache.size();
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public Exchange receive(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint);
    }

    @Override
    public Exchange receive(Endpoint endpoint) {
        return this.receive(endpoint.getEndpointUri());
    }

    @Override
    public Exchange receive(String endpointUri, long timeout) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint, timeout);
    }

    @Override
    public Exchange receive(Endpoint endpoint, long timeout) {
        return this.receive(endpoint.getEndpointUri(), timeout);
    }

    @Override
    public Exchange receiveNoWait(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receiveNoWait(endpoint);
    }

    @Override
    public Exchange receiveNoWait(Endpoint endpoint) {
        return this.receiveNoWait(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receiveBody(String endpointUri) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    @Override
    public Object receiveBody(Endpoint endpoint) {
        return this.receiveBody(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receiveBody(String endpointUri, long timeout) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri, timeout);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    @Override
    public Object receiveBody(Endpoint endpoint, long timeout) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receiveBodyNoWait(String endpointUri) {
        Object answer = null;
        Exchange exchange = this.receiveNoWait(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    @Override
    public Object receiveBodyNoWait(Endpoint endpoint) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBody(String endpointUri, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.context.getTypeConverter().convertTo(type, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBody(String endpointUri, long timeout, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receive(endpointUri, timeout);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.context.getTypeConverter().convertTo(type, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, long timeout, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBodyNoWait(String endpointUri, Class<T> type) {
        Object answer = null;
        Exchange exchange = this.receiveNoWait(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.context.getTypeConverter().convertTo(type, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBodyNoWait(Endpoint endpoint, Class<T> type) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri(), type);
    }

    @Override
    public void doneUoW(Exchange exchange) {
        try {
            if (exchange == null) {
                return;
            }
            if (exchange.getUnitOfWork() == null) {
                List<Synchronization> synchronizations = exchange.handoverCompletions();
                UnitOfWorkHelper.doneSynchronizations(exchange, synchronizations, LOG);
            } else {
                exchange.getUnitOfWork().done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        return CamelContextHelper.getMandatoryEndpoint(this.context, endpointUri);
    }

    protected Object extractResultBody(Exchange result) {
        Object answer = null;
        if (result != null) {
            if (result.getException() != null) {
                throw ObjectHelper.wrapRuntimeCamelException(result.getException());
            }
            answer = result.hasOut() ? result.getOut().getBody() : result.getIn().getBody();
        }
        return answer;
    }

    private ConsumerCache getConsumerCache() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ConsumerTemplate has not been started");
        }
        return this.consumerCache;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = this.maximumCacheSize > 0 ? new ConsumerCache((Object)this, this.context, this.maximumCacheSize) : new ConsumerCache(this, this.context);
        }
        ServiceHelper.startService(this.consumerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumerCache);
        this.consumerCache = null;
    }
}

