/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.Processor;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ThreadPoolProfile;

@XmlRootElement(name="threads")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadsDefinition
extends OutputDefinition<ThreadsDefinition>
implements ExecutorServiceAwareDefinition<ThreadsDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Integer poolSize;
    @XmlAttribute
    private Integer maxPoolSize;
    @XmlAttribute
    private Long keepAliveTime;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit;
    @XmlAttribute
    private Integer maxQueueSize;
    @XmlAttribute
    private String threadName = "Threads";
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy;
    @XmlAttribute
    private Boolean callerRunsWhenRejected;

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        String name = this.getThreadName() != null ? this.getThreadName() : "Threads";
        this.executorService = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, name, this);
        if (this.executorService == null) {
            ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
            ThreadPoolProfile profile = new ThreadPoolProfileBuilder(name).poolSize(this.getPoolSize()).maxPoolSize(this.getMaxPoolSize()).keepAliveTime(this.getKeepAliveTime(), this.getTimeUnit()).maxQueueSize(this.getMaxQueueSize()).rejectedPolicy(this.getRejectedPolicy()).build();
            this.executorService = manager.newThreadPool((Object)this, name, profile);
        }
        ThreadsProcessor thread = new ThreadsProcessor(routeContext.getCamelContext(), this.executorService);
        if (this.getCallerRunsWhenRejected() == null) {
            thread.setCallerRunsWhenRejected(true);
        } else {
            thread.setCallerRunsWhenRejected(this.getCallerRunsWhenRejected());
        }
        ArrayList<Processor> pipe = new ArrayList<Processor>(2);
        pipe.add(thread);
        pipe.add(this.createChildProcessor(routeContext, true));
        return new Pipeline(routeContext.getCamelContext(), pipe){

            @Override
            public String toString() {
                return "Threads[" + ThreadsDefinition.this.getOutputs() + "]";
            }
        };
    }

    @Override
    public String getLabel() {
        return "threads";
    }

    @Override
    public String getShortName() {
        return "threads";
    }

    @Override
    public String toString() {
        return "Threads[" + this.getOutputs() + "]";
    }

    @Override
    public ThreadsDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ThreadsDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public ThreadsDefinition poolSize(int poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadsDefinition maxPoolSize(int maxPoolSize) {
        this.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadsDefinition keepAliveTime(long keepAliveTime) {
        this.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadsDefinition timeUnit(TimeUnit keepAliveTimeUnits) {
        this.setTimeUnit(keepAliveTimeUnits);
        return this;
    }

    public ThreadsDefinition maxQueueSize(int maxQueueSize) {
        this.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadsDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ThreadsDefinition threadName(String threadName) {
        this.setThreadName(threadName);
        return this;
    }

    public ThreadsDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public Boolean getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(Boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }
}

