/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.container.standalone;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Hashtable;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryConfigBuilder;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.event.ExecutionEventListener;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.UnknownProfileMemberException;

public class StandaloneExecutionContext
implements ExecutionContext {
    private ProfileSet targetProfileSet;
    private Hashtable attributes = new Hashtable();
    private ContentDeliveryConfig deliveryConfig;
    private URI docSource;
    private String contentEncoding;
    private ApplicationContext context;
    private ExecutionEventListener executionListener;
    private Throwable terminationError;
    private boolean isDefaultSerializationOn;

    public StandaloneExecutionContext(String targetProfile, ApplicationContext context, VisitorConfigMap extendedVisitorConfigMap) throws UnknownProfileMemberException {
        this(targetProfile, context, "UTF-8", extendedVisitorConfigMap);
    }

    public StandaloneExecutionContext(String targetProfile, ApplicationContext context, String contentEncoding, VisitorConfigMap extendedVisitorConfigMap) throws UnknownProfileMemberException {
        if (targetProfile == null) {
            throw new IllegalArgumentException("null 'targetProfile' arg in constructor call.");
        }
        if (context == null) {
            throw new IllegalArgumentException("null 'context' arg in constructor call.");
        }
        this.context = context;
        this.setContentEncoding(contentEncoding);
        this.targetProfileSet = context.getProfileStore().getProfileSet(targetProfile);
        this.deliveryConfig = ContentDeliveryConfigBuilder.getConfig(this.targetProfileSet, context, extendedVisitorConfigMap);
        this.isDefaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, this.deliveryConfig);
    }

    public void setDocumentSource(URI docSource) {
        this.docSource = docSource;
    }

    public URI getDocumentSource() {
        if (this.docSource == null) {
            return ExecutionContext.DOCUMENT_URI;
        }
        return this.docSource;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public ProfileSet getTargetProfiles() {
        return this.targetProfileSet;
    }

    public ContentDeliveryConfig getDeliveryConfig() {
        return this.deliveryConfig;
    }

    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        contentEncoding = contentEncoding == null ? "UTF-8" : contentEncoding;
        try {
            "".getBytes(contentEncoding);
        }
        catch (UnsupportedEncodingException e) {
            IllegalArgumentException argE = new IllegalArgumentException("Invalid 'contentEncoding' arg [" + contentEncoding + "].  This encoding is not supported.");
            argE.initCause(e);
            throw argE;
        }
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding == null ? "UTF-8" : this.contentEncoding;
    }

    public void setEventListener(ExecutionEventListener listener) {
        this.executionListener = listener;
    }

    public ExecutionEventListener getEventListener() {
        return this.executionListener;
    }

    public void setTerminationError(Throwable terminationError) {
        this.terminationError = terminationError;
    }

    public Throwable getTerminationError() {
        return this.terminationError;
    }

    public String getConfigParameter(String name) {
        return this.getConfigParameter(name, null);
    }

    public String getConfigParameter(String name, String defaultVal) {
        return ParameterAccessor.getStringParameter(name, defaultVal, this.deliveryConfig);
    }

    public boolean isDefaultSerializationOn() {
        return this.isDefaultSerializationOn;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public String toString() {
        return this.attributes.toString();
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }
}

