/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.dtd.DTDStore;
import org.milyn.event.types.ConfigBuilderEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentDeliveryConfig
implements ContentDeliveryConfig {
    private ApplicationContext applicationContext;
    private Map<String, List<SmooksResourceConfiguration>> resourceConfigTable = new LinkedHashMap<String, List<SmooksResourceConfiguration>>();
    private Map objectsTable = new LinkedHashMap();
    private DTDStore.DTDObjectContainer dtd;
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private Boolean isDefaultSerializationOn = null;
    private static final Vector EMPTY_LIST = new Vector();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List getSmooksResourceConfigurations(String selector) {
        return this.resourceConfigTable.get(selector.toLowerCase());
    }

    public void setSmooksResourceConfigurations(Map<String, List<SmooksResourceConfiguration>> resourceConfigTable) {
        this.resourceConfigTable = resourceConfigTable;
    }

    @Override
    public Map<String, List<SmooksResourceConfiguration>> getSmooksResourceConfigurations() {
        return this.resourceConfigTable;
    }

    @Override
    public List getObjects(String selector) {
        Vector<Object> objects = (Vector<Object>)this.objectsTable.get(selector = selector.toLowerCase());
        if (objects == null) {
            List<SmooksResourceConfiguration> unitDefs = this.resourceConfigTable.get(selector);
            if (unitDefs != null && unitDefs.size() > 0) {
                objects = new Vector<Object>(unitDefs.size());
                if (this.applicationContext == null) {
                    throw new IllegalStateException("Call to getObjects() before the setApplicationContext() was called.");
                }
                for (int i = 0; i < unitDefs.size(); ++i) {
                    SmooksResourceConfiguration resConfig = unitDefs.get(i);
                    objects.add(this.applicationContext.getStore().getObject(resConfig));
                }
            } else {
                objects = EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    @Override
    public DTDStore.DTDObjectContainer getDTD() {
        return this.dtd;
    }

    public void setDtd(DTDStore.DTDObjectContainer dtd) {
        this.dtd = dtd;
    }

    @Override
    public List<ConfigBuilderEvent> getConfigBuilderEvents() {
        return this.configBuilderEvents;
    }

    @Override
    public boolean isDefaultSerializationOn() {
        if (this.isDefaultSerializationOn == null) {
            this.isDefaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, this);
        }
        return this.isDefaultSerializationOn;
    }
}

