/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.AbstractContentDeliveryConfig;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.Filter;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.ordering.Sorter;
import org.milyn.delivery.sax.SAXElementVisitorMap;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitChildren;
import org.milyn.delivery.sax.SmooksSAXFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXContentDeliveryConfig
extends AbstractContentDeliveryConfig {
    private ContentHandlerConfigMapTable<SAXVisitBefore> visitBefores;
    private ContentHandlerConfigMapTable<SAXVisitChildren> childVisitors = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitAfter> visitAfters;
    private ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables;
    private ContentHandlerConfigMapTable<ExecutionLifecycleCleanable> execCleanables;
    private Map<String, SAXElementVisitorMap> optimizedVisitorConfig = new HashMap<String, SAXElementVisitorMap>();

    public ContentHandlerConfigMapTable<SAXVisitBefore> getVisitBefores() {
        return this.visitBefores;
    }

    public void setVisitBefores(ContentHandlerConfigMapTable<SAXVisitBefore> visitBefores) {
        this.visitBefores = visitBefores;
    }

    public ContentHandlerConfigMapTable<SAXVisitChildren> getChildVisitors() {
        return this.childVisitors;
    }

    public ContentHandlerConfigMapTable<SAXVisitAfter> getVisitAfters() {
        return this.visitAfters;
    }

    public void setVisitAfters(ContentHandlerConfigMapTable<SAXVisitAfter> visitAfters) {
        this.visitAfters = visitAfters;
    }

    public ContentHandlerConfigMapTable<VisitLifecycleCleanable> getVisitCleanables() {
        return this.visitCleanables;
    }

    public void setVisitCleanables(ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables) {
        this.visitCleanables = visitCleanables;
    }

    public ContentHandlerConfigMapTable<ExecutionLifecycleCleanable> getExecCleanables() {
        return this.execCleanables;
    }

    public void setExecCleanables(ContentHandlerConfigMapTable<ExecutionLifecycleCleanable> execCleanables) {
        this.execCleanables = execCleanables;
    }

    public Map<String, SAXElementVisitorMap> getOptimizedVisitorConfig() {
        return this.optimizedVisitorConfig;
    }

    @Override
    public Filter newFilter(ExecutionContext executionContext) {
        return new SmooksSAXFilter(executionContext);
    }

    @Override
    public void sort() throws SmooksConfigurationException {
        this.visitBefores.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.childVisitors.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.visitAfters.sort(Sorter.SortOrder.CONSUMERS_FIRST);
    }

    public void optimizeConfig() {
        if (this.visitBefores == null || this.visitAfters == null) {
            throw new IllegalStateException("Illegal call to setChildVisitors() before setVisitBefores() and setVisitAfters() are called.");
        }
        this.extractChildVisitors();
        HashSet<String> elementNames = new HashSet<String>();
        elementNames.addAll(this.visitBefores.getTable().keySet());
        elementNames.addAll(this.visitAfters.getTable().keySet());
        for (String elementName : elementNames) {
            SAXElementVisitorMap entry = new SAXElementVisitorMap();
            entry.setVisitBefores(this.visitBefores.getTable().get(elementName));
            entry.setChildVisitors(this.childVisitors.getTable().get(elementName));
            entry.setVisitAfters(this.visitAfters.getTable().get(elementName));
            entry.setVisitCleanables(this.visitCleanables.getTable().get(elementName));
            this.optimizedVisitorConfig.put(elementName, entry);
        }
    }

    public SAXElementVisitorMap getCombinedOptimizedConfig(String[] elementNames) {
        SAXElementVisitorMap combinedConfig = new SAXElementVisitorMap();
        combinedConfig.setVisitBefores(new ArrayList<ContentHandlerConfigMap<SAXVisitBefore>>());
        combinedConfig.setChildVisitors(new ArrayList<ContentHandlerConfigMap<SAXVisitChildren>>());
        combinedConfig.setVisitAfters(new ArrayList<ContentHandlerConfigMap<SAXVisitAfter>>());
        combinedConfig.setVisitCleanables(new ArrayList<ContentHandlerConfigMap<VisitLifecycleCleanable>>());
        for (String elementName : elementNames) {
            SAXElementVisitorMap elementConfig = this.optimizedVisitorConfig.get(elementName.toLowerCase());
            if (elementConfig == null) continue;
            List<ContentHandlerConfigMap<SAXVisitBefore>> elementVisitBefores = elementConfig.getVisitBefores();
            List<ContentHandlerConfigMap<SAXVisitChildren>> elementChildVisitors = elementConfig.getChildVisitors();
            List<ContentHandlerConfigMap<SAXVisitAfter>> elementVisitAfteres = elementConfig.getVisitAfters();
            List<ContentHandlerConfigMap<VisitLifecycleCleanable>> elementVisitCleanables = elementConfig.getVisitCleanables();
            if (elementVisitBefores != null) {
                combinedConfig.getVisitBefores().addAll(elementVisitBefores);
            }
            if (elementChildVisitors != null) {
                combinedConfig.getChildVisitors().addAll(elementChildVisitors);
            }
            if (elementVisitAfteres != null) {
                combinedConfig.getVisitAfters().addAll(elementVisitAfteres);
            }
            if (elementVisitCleanables == null) continue;
            combinedConfig.getVisitCleanables().addAll(elementVisitCleanables);
        }
        if (combinedConfig.getVisitBefores().isEmpty()) {
            combinedConfig.setVisitBefores(null);
        }
        if (combinedConfig.getChildVisitors().isEmpty()) {
            combinedConfig.setChildVisitors(null);
        }
        if (combinedConfig.getVisitAfters().isEmpty()) {
            combinedConfig.setVisitAfters(null);
        }
        if (combinedConfig.getVisitCleanables().isEmpty()) {
            combinedConfig.setVisitCleanables(null);
        }
        if (combinedConfig.getVisitBefores() == null && combinedConfig.getChildVisitors() == null && combinedConfig.getVisitAfters() == null) {
            return null;
        }
        return combinedConfig;
    }

    private void extractChildVisitors() {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitBefore>>>> beforeMappings = this.visitBefores.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitBefore>>> beforeMapping : beforeMappings) {
            List<ContentHandlerConfigMap<SAXVisitBefore>> elementMappings = beforeMapping.getValue();
            for (ContentHandlerConfigMap<SAXVisitBefore> elementMapping : elementMappings) {
                String elementName = beforeMapping.getKey();
                SAXVisitBefore handler = elementMapping.getContentHandler();
                if (!(handler instanceof SAXVisitChildren) || handler instanceof SAXVisitAfter) continue;
                this.childVisitors.addMapping(elementName, elementMapping.getResourceConfig(), (SAXVisitChildren)((Object)handler));
            }
        }
        Set<Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitAfter>>>> afterMappings = this.visitAfters.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitAfter>>> afterMapping : afterMappings) {
            List<ContentHandlerConfigMap<SAXVisitAfter>> elementMappings = afterMapping.getValue();
            for (ContentHandlerConfigMap<SAXVisitAfter> elementMapping : elementMappings) {
                String elementName = afterMapping.getKey();
                SAXVisitAfter handler = elementMapping.getContentHandler();
                if (!(handler instanceof SAXVisitChildren)) continue;
                this.childVisitors.addMapping(elementName, elementMapping.getResourceConfig(), (SAXVisitChildren)((Object)handler));
            }
        }
    }
}

