/*
 * Decompiled with CFR 0.152.
 */
package org.drools.fluent.simulation.impl;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.command.Command;
import org.drools.command.GetVariableCommand;
import org.drools.command.NewKnowledgeBaseCommand;
import org.drools.command.NewStatefulKnowledgeSessionCommand;
import org.drools.command.SetVariableCommandFromLastReturn;
import org.drools.command.builder.NewKnowledgeBuilderCommand;
import org.drools.fluent.VariableContext;
import org.drools.fluent.knowledge.KnowledgeBaseSimFluent;
import org.drools.fluent.knowledge.KnowledgeBuilderSimFluent;
import org.drools.fluent.knowledge.impl.DefaultKnowledgeBaseSimFluent;
import org.drools.fluent.knowledge.impl.DefaultKnowledgeBuilderSimFluent;
import org.drools.fluent.session.StatefulKnowledgeSessionSimFluent;
import org.drools.fluent.session.impl.DefaultStatefulKnowledgeSessionSimFluent;
import org.drools.fluent.simulation.SimulationFluent;
import org.drools.fluent.test.impl.AbstractTestableFluent;
import org.drools.fluent.test.impl.MapVariableContext;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.simulation.Simulation;
import org.drools.simulation.SimulationPath;
import org.drools.simulation.SimulationStep;
import org.drools.simulation.impl.SimulationImpl;
import org.drools.simulation.impl.SimulationPathImpl;
import org.drools.simulation.impl.SimulationStepImpl;
import org.drools.simulation.impl.Simulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSimulationFluent
extends AbstractTestableFluent<SimulationFluent>
implements SimulationFluent {
    private Simulation simulation = new SimulationImpl();
    private VariableContext variableContext = new MapVariableContext();
    private SimulationPath activePath = null;
    private int pathCounter = 0;
    private SimulationStep activeStep = null;
    private String activeKnowledgeBuilderId = null;
    private int knowledgeBuilderCounter = 0;
    private String activeKnowledgeBaseId = null;
    private int knowledgeBaseCounter = 0;
    private String activeKnowledgeSessionId = null;
    private int knowledgeSessionCounter = 0;

    public <P> VariableContext<P> getVariableContext() {
        return this.variableContext;
    }

    public SimulationFluent newPath() {
        String pathId = "path" + this.pathCounter;
        ++this.pathCounter;
        this.activeKnowledgeSessionId = null;
        return this.newPath(pathId);
    }

    @Override
    public SimulationFluent newPath(String id) {
        this.activePath = new SimulationPathImpl(this.simulation, id);
        this.simulation.getPaths().put(id, this.activePath);
        this.activeStep = null;
        return this;
    }

    @Override
    public SimulationFluent getPath(String id) {
        this.activePath = (SimulationPath)this.simulation.getPaths().get(id);
        if (this.activePath == null) {
            throw new IllegalArgumentException("There is no path with path id (" + id + ") created yet." + " Call newPath(id) first.");
        }
        List steps = this.activePath.getSteps();
        this.activeStep = (SimulationStep)steps.get(steps.size() - 1);
        return this;
    }

    private void assureActivePath() {
        if (this.activePath == null) {
            this.newPath();
        }
    }

    public SimulationPath getActivePath() {
        return this.activePath;
    }

    @Override
    public SimulationFluent newStep(long distanceMillis) {
        this.assureActivePath();
        this.activeStep = new SimulationStepImpl(this.activePath, distanceMillis);
        this.activePath.getSteps().add(this.activeStep);
        return this;
    }

    @Override
    public SimulationFluent newStep(long distanceMillis, TimeUnit timeUnit) {
        return this.newStep(timeUnit.toMillis(distanceMillis));
    }

    @Override
    public SimulationFluent newRelativeStep(long relativeDistanceMillis) {
        if (this.activeStep == null) {
            return this.newStep(relativeDistanceMillis);
        }
        return this.newStep(this.activeStep.getDistanceMillis() + relativeDistanceMillis);
    }

    @Override
    public SimulationFluent newRelativeStep(long relativeDistance, TimeUnit timeUnit) {
        return this.newRelativeStep(timeUnit.toMillis(relativeDistance));
    }

    private void assureActiveStep() {
        if (this.activeStep == null) {
            this.newStep(0L);
        }
    }

    public SimulationStep getActiveStep() {
        return this.activeStep;
    }

    @Override
    public SimulationFluent addCommand(Command command) {
        this.activeStep.getCommands().add(command);
        return this;
    }

    @Override
    public String getActiveKnowledgeBuilderId() {
        return this.activeKnowledgeBuilderId;
    }

    @Override
    public KnowledgeBuilderSimFluent newKnowledgeBuilder() {
        String knowledgeBuilderId = KnowledgeBuilder.class.getName() + this.knowledgeBuilderCounter;
        ++this.knowledgeBuilderCounter;
        return this.newKnowledgeBuilder(knowledgeBuilderId);
    }

    public KnowledgeBuilderSimFluent newKnowledgeBuilder(String id) {
        this.assureActiveStep();
        this.activeKnowledgeBuilderId = id;
        this.addCommand((Command)new NewKnowledgeBuilderCommand(null, null));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(KnowledgeBuilder.class.getName()));
        this.activeKnowledgeBaseId = null;
        return new DefaultKnowledgeBuilderSimFluent(this);
    }

    @Override
    public KnowledgeBuilderSimFluent getKnowledgeBuilder() {
        this.assureActiveStep();
        if (this.activeKnowledgeBuilderId == null) {
            throw new IllegalStateException("There is no activeKnowledgeBuilder. Call newKnowledgeBuilder() instead.");
        }
        this.activeKnowledgeBaseId = null;
        return new DefaultKnowledgeBuilderSimFluent(this);
    }

    @Override
    public KnowledgeBuilderSimFluent getKnowledgeBuilder(String id) {
        this.assureActiveStep();
        this.activeKnowledgeBuilderId = id;
        this.addCommand((Command)new GetVariableCommand(id));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(KnowledgeBuilder.class.getName()));
        this.activeKnowledgeBaseId = null;
        return new DefaultKnowledgeBuilderSimFluent(this);
    }

    @Override
    public String getActiveKnowledgeBaseId() {
        return this.activeKnowledgeBaseId;
    }

    @Override
    public KnowledgeBaseSimFluent newKnowledgeBase() {
        String knowledgeBaseId = KnowledgeBase.class.getName() + this.knowledgeBaseCounter;
        ++this.knowledgeBaseCounter;
        return this.newKnowledgeBase(knowledgeBaseId);
    }

    public KnowledgeBaseSimFluent newKnowledgeBase(String id) {
        this.assureActiveStep();
        this.activeKnowledgeBaseId = id;
        this.addCommand((Command)new NewKnowledgeBaseCommand(null));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(KnowledgeBase.class.getName()));
        return new DefaultKnowledgeBaseSimFluent(this);
    }

    @Override
    public KnowledgeBaseSimFluent getKnowledgeBase() {
        this.assureActiveStep();
        if (this.activeKnowledgeBaseId == null) {
            throw new IllegalStateException("There is no activeKnowledgeBase. Call newKnowledgeBase() instead.");
        }
        return new DefaultKnowledgeBaseSimFluent(this);
    }

    @Override
    public KnowledgeBaseSimFluent getKnowledgeBase(String id) {
        this.assureActiveStep();
        this.activeKnowledgeBaseId = id;
        this.addCommand((Command)new GetVariableCommand(id));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(KnowledgeBase.class.getName()));
        return new DefaultKnowledgeBaseSimFluent(this);
    }

    public void assureActiveKnowledgeBase() {
        this.assureActiveStep();
        if (this.activeKnowledgeBaseId == null) {
            this.newKnowledgeBase().addKnowledgePackages();
        }
    }

    @Override
    public String getActiveKnowledgeSessionId() {
        return this.activeKnowledgeSessionId;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newStatefulKnowledgeSession() {
        String knowledgeSessionId = StatefulKnowledgeSession.class.getName() + this.knowledgeSessionCounter;
        ++this.knowledgeSessionCounter;
        return this.newStatefulKnowledgeSession(knowledgeSessionId);
    }

    public StatefulKnowledgeSessionSimFluent newStatefulKnowledgeSession(String id) {
        this.assureActiveKnowledgeBase();
        this.activeKnowledgeSessionId = id;
        KnowledgeSessionConfiguration ksessionConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksessionConf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        this.addCommand((Command)new NewStatefulKnowledgeSessionCommand(ksessionConf));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(StatefulKnowledgeSession.class.getName()));
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent getStatefulKnowledgeSession() {
        this.assureActiveKnowledgeBase();
        if (this.activeKnowledgeSessionId == null) {
            throw new IllegalStateException("There is no activeKnowledgeSession. Call newStatefulKnowledgeSession() instead.");
        }
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent getStatefulKnowledgeSession(String id) {
        this.assureActiveKnowledgeBase();
        this.activeKnowledgeSessionId = id;
        this.addCommand((Command)new GetVariableCommand(id));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(StatefulKnowledgeSession.class.getName()));
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public void runSimulation() {
        this.runSimulation(new Date().getTime());
    }

    @Override
    public void runSimulation(long startTimeMillis) {
        Simulator simulator = new Simulator(this.simulation, startTimeMillis);
        simulator.run();
    }
}

