/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public final class UrlUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(UrlUtils.class);
    private static final String[] RESERVED_CHARS = new String[]{"+"};
    private static final String[] ENCODED_CHARS = new String[]{"%2b"};

    private UrlUtils() {
    }

    public static String urlDecode(String value, String enc) {
        try {
            value = URLDecoder.decode(value, enc);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning("UTF-8 encoding can not be used to decode " + value);
        }
        return value;
    }

    public static String urlDecode(String value) {
        return UrlUtils.urlDecode(value, "UTF-8");
    }

    public static String pathDecode(String value) {
        for (int i = 0; i < RESERVED_CHARS.length; ++i) {
            if (value.indexOf(RESERVED_CHARS[i]) == -1) continue;
            value = value.replace(RESERVED_CHARS[i], ENCODED_CHARS[i]);
        }
        return UrlUtils.urlDecode(value);
    }
}

