/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.mocks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import junit.framework.AssertionFailedError;
import org.apache.aries.mocks.BundleMock;
import org.apache.aries.unittest.mocks.Skeleton;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleContextMock {
    private static Map<String, List<ServiceData>> registry = new HashMap<String, List<ServiceData>>();
    private static List<Bundle> bundles = new ArrayList<Bundle>();
    private static List<ServiceListener> listeners = new ArrayList<ServiceListener>();
    private static long nextId = 0L;
    private Bundle bundle;

    public BundleContextMock() {
        this.bundle = Skeleton.newMock(new BundleMock("test." + new Random(System.currentTimeMillis()).nextInt(), new Hashtable()), Bundle.class);
    }

    public BundleContextMock(Bundle b) {
        this.bundle = b;
    }

    public static void assertServiceExists(String interfaceName) {
        Assert.assertTrue((String)("No service registered with interface " + interfaceName + ". Services found: " + registry.keySet()), (boolean)registry.containsKey(interfaceName));
    }

    public static void assertNoServiceExists(String interfaceName) {
        Assert.assertFalse((String)("Services registered with interface " + interfaceName + ". Services found: " + registry.keySet()), (boolean)registry.containsKey(interfaceName));
    }

    public ServiceRegistration registerService(String interFace, Object service, Dictionary<String, Object> properties) {
        try {
            Class<?> clazz = Class.forName(interFace, false, service.getClass().getClassLoader());
            if (!clazz.isInstance(service) && !(service instanceof ServiceFactory)) {
                throw new AssertionFailedError("The service " + service + " does not implement " + interFace);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this.registerService(new String[]{interFace}, service, properties);
    }

    public ServiceRegistration registerService(String[] interfaces, Object service, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ServiceData data = new ServiceData();
        properties.put("objectClass", interfaces);
        properties.put("service.id", nextId++);
        if (service instanceof ServiceFactory) {
            data.serviceImpl = (ServiceFactory)service;
        } else {
            data.serviceImpl = new MockServiceFactory(service);
        }
        ServiceData.access$402(data, interfaces);
        data.registeringBundle = this.bundle;
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            data.serviceProps.put(key, properties.get(key));
        }
        data.register();
        return Skeleton.newMock(data, ServiceRegistration.class);
    }

    public static Object getService(String interfaceName, Bundle bundle) {
        List<ServiceData> datum = registry.get(interfaceName);
        if (datum == null) {
            return null;
        }
        if (datum.isEmpty()) {
            return null;
        }
        ServiceRegistration reg = Skeleton.newMock(ServiceRegistration.class);
        return datum.iterator().next().serviceImpl.getService(bundle, reg);
    }

    public ServiceReference[] getServiceReferences(String className, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs;
        ArrayList<ServiceData> data = new ArrayList<ServiceData>();
        if (className != null) {
            List<ServiceData> tmpData = registry.get(className);
            if (tmpData != null) {
                data.addAll(tmpData);
            }
        } else {
            data = new ArrayList();
            for (List<ServiceData> value : registry.values()) {
                data.addAll(value);
            }
        }
        if (data == null) {
            refs = null;
        } else {
            if (filter != null) {
                Filter f = FrameworkUtil.createFilter((String)filter);
                Iterator it = data.iterator();
                while (it.hasNext()) {
                    ServiceData sd = (ServiceData)it.next();
                    if (f.match(sd.getProperties())) continue;
                    it.remove();
                }
            }
            if (data.isEmpty()) {
                return null;
            }
            refs = new ServiceReference[data.size()];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = Skeleton.newMock(data.get(i), ServiceReference.class);
            }
        }
        return refs;
    }

    public ServiceReference getServiceReference(String className) {
        try {
            ServiceReference[] refs = this.getServiceReferences(className, null);
            if (refs != null) {
                return refs[0];
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServiceReference[] getAllServiceReferences(String className, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(className, filter);
    }

    public Object getService(ServiceReference ref) {
        ServiceData data = (ServiceData)Skeleton.getSkeleton(ref).getTemplateObject();
        return data.serviceImpl.getService(this.getBundle(), Skeleton.newMock(data, ServiceRegistration.class));
    }

    public Bundle installBundle(String location, InputStream is) throws BundleException {
        Bundle b;
        try {
            JarInputStream jis = new JarInputStream(is);
            Manifest man = jis.getManifest();
            b = this.createBundle(man, null);
        }
        catch (IOException e) {
            throw new BundleException(e.getMessage(), (Throwable)e);
        }
        return b;
    }

    private Bundle createBundle(Manifest man, String location) throws MalformedURLException {
        Attributes attribs = man.getMainAttributes();
        String symbolicName = attribs.getValue("Bundle-SymbolicName");
        Hashtable<String, Object> attribMap = new Hashtable<String, Object>();
        for (Map.Entry<Object, Object> entry : attribs.entrySet()) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            attribMap.put(name.toString(), entry.getValue());
        }
        BundleMock mock = new BundleMock(symbolicName, attribMap, location);
        mock.addToClassPath(new File("build/unittest/classes").toURL());
        Bundle b = Skeleton.newMock(mock, Bundle.class);
        bundles.add(b);
        return b;
    }

    public Bundle installBundle(String location) throws BundleException {
        try {
            URI uri = new URI(location.replaceAll(" ", "%20"));
            File baseDir = new File(uri);
            Manifest man = null;
            if (baseDir.isDirectory()) {
                man = new Manifest(new FileInputStream(new File(baseDir, "META-INF/MANIFEST.MF")));
            } else {
                FileInputStream is = new FileInputStream(baseDir);
                JarInputStream jis = new JarInputStream(is);
                man = jis.getManifest();
                jis.close();
                if (man == null) {
                    throw new BundleException("Null manifest");
                }
            }
            return this.createBundle(man, location);
        }
        catch (IOException e) {
            throw new BundleException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new BundleException(e.getMessage(), (Throwable)e);
        }
    }

    public Bundle[] getBundles() {
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        listeners.add(new FilteredServiceListener(filter, listener));
    }

    public void addServiceListener(ServiceListener listener) {
        listeners.add(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        listeners.remove(new FilteredServiceListener(null, listener));
    }

    public String getProperty(String name) {
        if ("org.osgi.framework.version".equals(name)) {
            return "4.1";
        }
        if (System.getProperty(name) != null) {
            return System.getProperty(name);
        }
        return "";
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public static void clear() {
        registry.clear();
        bundles.clear();
        listeners.clear();
        nextId = 0L;
    }

    public static List<ServiceListener> getServiceListeners() {
        return listeners;
    }

    public void addBundle(Bundle b) {
        bundles.add(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceData
    implements Comparable<ServiceReference> {
        private ServiceFactory serviceImpl;
        private final Hashtable<String, Object> serviceProps = new Hashtable();
        private String[] interfaceNames;
        private Bundle registeringBundle;

        private ServiceData() {
        }

        public void unregister() {
            for (String interfaceName : this.interfaceNames) {
                List list = (List)registry.get(interfaceName);
                if (list == null) continue;
                list.remove(this);
                if (!list.isEmpty()) continue;
                registry.remove(interfaceName);
            }
            this.notifyAllListeners(4);
            this.registeringBundle = null;
        }

        public void register() {
            for (String interfaceName : this.interfaceNames) {
                ArrayList<ServiceData> list = (ArrayList<ServiceData>)registry.get(interfaceName);
                if (list == null) {
                    list = new ArrayList<ServiceData>();
                    registry.put(interfaceName, list);
                }
                list.add(this);
            }
            this.notifyAllListeners(1);
        }

        private void notifyAllListeners(int eventType) {
            ArrayList copy = new ArrayList(listeners.size());
            copy.addAll(listeners);
            for (ServiceListener listener : copy) {
                listener.serviceChanged(new ServiceEvent(eventType, Skeleton.newMock(this, ServiceReference.class)));
            }
        }

        public void setProperties(Dictionary<String, Object> newProps) {
            newProps.put("objectClass", this.serviceProps.get("objectClass"));
            newProps.put("service.id", this.serviceProps.get("service.id"));
            Enumeration<String> keys = newProps.keys();
            this.serviceProps.clear();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.serviceProps.put(key, newProps.get(key));
            }
            this.notifyAllListeners(2);
        }

        public boolean isAssignableTo(Bundle b, String className) {
            String iName;
            boolean result = false;
            String[] arr$ = this.interfaceNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(result = (iName = arr$[i$]).equals(className)); ++i$) {
            }
            return result;
        }

        public Object getProperty(String key) {
            return this.serviceProps.get(key);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof ServiceData) {
                ServiceData other = (ServiceData)o;
                return this.serviceImpl == other.serviceImpl;
            }
            return false;
        }

        public int hashCode() {
            return this.serviceImpl.hashCode();
        }

        public String[] getPropertyKeys() {
            Enumeration<String> e = this.serviceProps.keys();
            String[] toReturn = new String[this.serviceProps.size()];
            for (int i = 0; i < this.serviceProps.size(); ++i) {
                toReturn[i] = e.nextElement();
            }
            return toReturn;
        }

        public Bundle getBundle() {
            return this.registeringBundle;
        }

        public ServiceReference getReference() {
            return Skeleton.newMock(this, ServiceReference.class);
        }

        public Hashtable<String, Object> getProperties() {
            return new Hashtable<String, Object>(this.serviceProps);
        }

        @Override
        public int compareTo(ServiceReference o) {
            int result;
            Integer otherRank;
            Integer rank = (Integer)this.serviceProps.get("service.ranking");
            if (rank == null) {
                rank = 0;
            }
            if ((otherRank = (Integer)o.getProperty("service.ranking")) == null) {
                otherRank = 0;
            }
            if ((result = rank.compareTo(otherRank)) == 0) {
                Long id = (Long)this.serviceProps.get("service.id");
                Long otherId = (Long)o.getProperty("service.id");
                return otherId.compareTo(id);
            }
            return result;
        }

        static /* synthetic */ String[] access$402(ServiceData x0, String[] x1) {
            x0.interfaceNames = x1;
            return x1;
        }
    }

    private static class FilteredServiceListener
    implements ServiceListener {
        private Filter filter;
        private final ServiceListener listener;

        public FilteredServiceListener(String f, ServiceListener l) {
            this.listener = l;
            if (f != null) {
                try {
                    this.filter = FrameworkUtil.createFilter((String)f);
                }
                catch (InvalidSyntaxException e) {
                    AssertionFailedError err = new AssertionFailedError("The filter " + f + " is invalid");
                    err.initCause((Throwable)e);
                    throw err;
                }
            }
        }

        public void serviceChanged(ServiceEvent arg0) {
            if (this.matches(arg0)) {
                this.listener.serviceChanged(arg0);
            }
        }

        private boolean matches(ServiceEvent arg0) {
            Object template;
            if (this.filter == null) {
                return true;
            }
            ServiceReference ref = arg0.getServiceReference();
            if (Skeleton.isSkeleton(ref) && (template = Skeleton.getSkeleton(ref).getTemplateObject()) instanceof ServiceData) {
                return this.filter.match(((ServiceData)template).getProperties());
            }
            return this.filter.match(ref);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FilteredServiceListener) {
                return this.listener.equals(((FilteredServiceListener)obj).listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    private static class MockServiceFactory
    implements ServiceFactory {
        private final Object service;

        public MockServiceFactory(Object obj) {
            this.service = obj;
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            return this.service;
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }
    }
}

