/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.helper;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.agent.KnowledgeAgent;
import org.drools.grid.ConnectionFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridConnection;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.conf.impl.GridPeerConfiguration;
import org.drools.grid.impl.GridImpl;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.remote.KnowledgeAgentRemoteClient;
import org.drools.grid.remote.QueryResultsRemoteClient;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.JpaWhitePages;
import org.drools.grid.service.directory.impl.WhitePagesLocalConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridHelper {
    public static Logger logger = LoggerFactory.getLogger(GridHelper.class);
    private static EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.grid");
    private static JpaWhitePages whitePages = new JpaWhitePages(emf);
    private static Map<String, GridNode> nodeCache = new HashMap<String, GridNode>();

    public static void reset() {
        if (emf != null && emf.isOpen()) {
            emf.close();
        }
        emf = Persistence.createEntityManagerFactory((String)"org.drools.grid");
        whitePages = new JpaWhitePages(emf);
    }

    public static Grid createGrid() {
        GridImpl gridHelper = new GridImpl(new HashMap<String, Object>());
        GridPeerConfiguration conf = new GridPeerConfiguration();
        WhitePagesLocalConfiguration wplConf = new WhitePagesLocalConfiguration();
        wplConf.setWhitePages(whitePages);
        conf.addConfiguration(wplConf);
        conf.configure(gridHelper);
        return gridHelper;
    }

    public static synchronized GridNode getGridNode(String name, Grid grid, boolean forceRemote) {
        if (logger.isDebugEnabled()) {
            logger.debug(" ### Grid Helper trying to locate GridNode: " + name);
        }
        if (nodeCache.containsKey(name)) {
            logger.debug(" ### Grid Helper found node " + name + " in cache");
            return nodeCache.get(name);
        }
        GridServiceDescription nGsd = grid.get(WhitePages.class).lookup(name);
        if (nGsd == null) {
            if (logger.isDebugEnabled()) {
                logger.error("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper DOES NOT Found a Node Descriptor for: " + name);
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper Found Node Descriptor: " + nGsd);
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### \t id: " + nGsd.getId());
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### \t Address size: " + nGsd.getAddresses().size());
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### \t Addresses: " + nGsd.getAddresses());
            for (String key : nGsd.getAddresses().keySet()) {
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " \t ### Address: " + nGsd.getAddresses().get(key));
            }
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### \t Interface: " + nGsd.getServiceInterface());
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### \t DATA: " + nGsd.getData());
        }
        ConnectionFactoryService csf = grid.get(ConnectionFactoryService.class);
        boolean allowsLocal = csf.isLocalAllowed();
        csf.setLocalAllowed(!forceRemote);
        GridConnection conn = csf.createConnection(nGsd);
        csf.setLocalAllowed(allowsLocal);
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper Create a Conection: " + name);
        }
        GridNode node = (GridNode)conn.connect();
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper found GridNode: (" + name + ") -> " + node);
        }
        nodeCache.put(name, node);
        return node;
    }

    public static QueryResultsRemoteClient getQueryResultRemoteClient(Grid grid, String nodeId, String sessionId, String queryName, String remoteResultsId) {
        GridServiceDescription<GridNode> gsd = GridHelper.getGridServiceDescriptor(grid, nodeId);
        GridNode node = GridHelper.getGridNode(nodeId, grid, false);
        String reverseId = node.get(sessionId, String.class);
        return new QueryResultsRemoteClient(queryName, reverseId, remoteResultsId, gsd, grid.get(ConversationManager.class));
    }

    public static KnowledgeAgent getKnowledgeAgentRemoteClient(Grid grid, String nodeId, String sessionId) {
        GridServiceDescription<GridNode> gsd = GridHelper.getGridServiceDescriptor(grid, nodeId);
        GridNode node = GridHelper.getGridNode(nodeId, grid, false);
        String reverseId = node.get(sessionId, String.class);
        if (logger.isDebugEnabled()) {
            logger.debug(" ### Grid Helper: Creating KnowledgeAgent Client for: reverseId: " + reverseId + " - session-id: " + sessionId);
        }
        return new KnowledgeAgentRemoteClient(reverseId, gsd, grid.get(ConversationManager.class));
    }

    private static GridServiceDescription<GridNode> getGridServiceDescriptor(Grid grid, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper trying to locate GridNode: " + name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### Grid Helper Looking up: " + name);
        }
        GridServiceDescription nGsd = grid.get(WhitePages.class).lookup(name);
        return nGsd;
    }

    public static StatefulKnowledgeSession getStatefulKnowledgeSession(Grid grid, String nodeId, String sessionId, boolean forceRemote) {
        GridNode node = GridHelper.getGridNode(nodeId, grid, forceRemote);
        logger.error("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### SESSION 2 : Looking session = " + sessionId + " in node = " + nodeId + " - " + node);
        if (logger.isDebugEnabled()) {
            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### SESSION 2 : Looking session = " + sessionId + " in node = " + nodeId + " - " + node);
        }
        StatefulKnowledgeSession kSession = node.get(sessionId, StatefulKnowledgeSession.class);
        return kSession;
    }
}

