/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.internal.commands;

import java.io.Serializable;
import org.drools.SessionConfiguration;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.runtime.conf.KnowledgeSessionOption;

public class KnowledgeSessionConfigurationRemoteCommands
implements Serializable {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetPropertyRemoteCommand
    implements GenericCommand<String> {
        private final String identifier;
        private final String propertyName;

        public GetPropertyRemoteCommand(String identifier, String propertyName) {
            this.identifier = identifier;
            this.propertyName = propertyName;
        }

        public String execute(Context context) {
            SessionConfiguration kconf = (SessionConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            return kconf.getProperty(this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetOptionRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;
        private final KnowledgeSessionOption option;

        public SetOptionRemoteCommand(String identifier, KnowledgeSessionOption option) {
            this.identifier = identifier;
            this.option = option;
        }

        public Void execute(Context context) {
            SessionConfiguration kconf = (SessionConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            kconf.setOption(this.option);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetPropertyRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;
        private final String propertyName;
        private final String propertyValue;

        public SetPropertyRemoteCommand(String identifier, String propertyName, String propertyValue) {
            this.identifier = identifier;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public Void execute(Context context) {
            SessionConfiguration kconf = (SessionConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            kconf.setProperty(this.propertyName, this.propertyValue);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewKnowledgeSessionConfigurationRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;

        public NewKnowledgeSessionConfigurationRemoteCommand(String identifier) {
            this.identifier = identifier;
        }

        public Void execute(Context context) {
            context.getContextManager().getContext("__TEMP__").set(this.identifier, (Object)new GridKnowledgeSessionConfiguration());
            return null;
        }
    }

    private static class GridKnowledgeSessionConfiguration
    extends SessionConfiguration {
        private String messageTimeout;
        private String messageMinWaitTime;

        private GridKnowledgeSessionConfiguration() {
        }

        public void setProperty(String name, String value) {
            if (name.equals("grid.ksession.message.timeout")) {
                this.messageTimeout = value;
            } else if (name.equals("grid.ksession.message.min.wait")) {
                this.messageMinWaitTime = value;
            } else {
                super.setProperty(name, value);
            }
        }

        public String getProperty(String name) {
            if (name.equals("grid.ksession.message.timeout")) {
                return this.messageTimeout;
            }
            if (name.equals("grid.ksession.message.min.wait")) {
                return this.messageMinWaitTime;
            }
            return super.getProperty(name);
        }
    }
}

