/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.KnowledgeBaseProviderRemoteClient;
import org.drools.grid.remote.KnowledgeBuilderProviderRemoteClient;
import org.drools.grid.remote.StatefulKnowledgeSessionRemoteClient;
import org.drools.grid.remote.mina.MinaConnector;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.ServiceRegistry;
import org.drools.util.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNodeRemoteClient<T>
implements GridNode {
    private static Logger logger = LoggerFactory.getLogger(GridNodeRemoteClient.class);
    private GridServiceDescription gsd;
    private Grid grid;
    private final Map<String, Object> localContext = new ConcurrentHashMap<String, Object>();
    private final ServiceRegistry serviceRegistry = ServiceRegistryImpl.getInstance();
    private MinaConnector connector = new MinaConnector();
    private boolean localProxy = false;

    public GridNodeRemoteClient(Grid grid, GridServiceDescription gsd) {
        this.gsd = gsd;
        this.grid = grid;
        this.init(this.localContext);
    }

    @Override
    public <T> T get(String identifier, Class<T> cls) {
        if (cls.isAssignableFrom(String.class)) {
            CommandImpl cmd = new CommandImpl("lookupKsessionId", Arrays.asList(identifier));
            ConversationManager connm = this.grid.get(ConversationManager.class);
            Object result = ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
            return (T)result;
        }
        if (cls.isAssignableFrom(StatefulKnowledgeSession.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " GNRC I'm now trying to locate a happy SKS... " + identifier);
            }
            CommandImpl cmd = new CommandImpl("lookupKsession", Arrays.asList(identifier));
            if (logger.isDebugEnabled()) {
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " GNRC I have the command ready");
            }
            ConversationManager connm = this.grid.get(ConversationManager.class);
            if (logger.isDebugEnabled()) {
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " GNRC I have the convo manager ready");
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " GNRC Sending to " + this.gsd.getAddresses().get("socket").getObject());
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " GNRC The gsd, whatever it is " + this.gsd.getId());
            }
            Object result = ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
            if (logger.isDebugEnabled()) {
                logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + "GNRC Ready to send it back");
            }
            return (T)new StatefulKnowledgeSessionRemoteClient((String)result, this.gsd, connm, null);
        }
        Object service = this.localContext.get(identifier);
        if (service == null) {
            service = this.serviceRegistry.get(cls);
        }
        return (T)service;
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        return this.get(serviceClass.getName(), serviceClass);
    }

    @Override
    public void set(String identifier, Object object) {
        if (!(object instanceof StatefulKnowledgeSessionRemoteClient)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        String localId = UUID.randomUUID().toString();
        CommandImpl cmd = new CommandImpl("registerKsession", Arrays.asList(identifier, ((StatefulKnowledgeSessionRemoteClient)object).getInstanceId()));
        ConversationManager connm = this.grid.get(ConversationManager.class);
        ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    @Override
    public String getId() {
        return this.gsd.getId();
    }

    @Override
    public void init(Object context) {
        this.localContext.put(KnowledgeBuilderFactoryService.class.getName(), new KnowledgeBuilderProviderRemoteClient(this.grid, this.gsd));
        this.localContext.put(KnowledgeBaseFactoryService.class.getName(), new KnowledgeBaseProviderRemoteClient(this.grid, this.gsd));
    }

    @Override
    public void dispose() {
        this.connector.close();
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean isLocalProxy() {
        return this.localProxy;
    }

    public void setLocalProxy(boolean proxy) {
        this.localProxy = proxy;
    }
}

