/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.internal.commands.KnowledgeSessionConfigurationRemoteCommands;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.conf.MultiValueKnowledgeSessionOption;
import org.drools.runtime.conf.SingleValueKnowledgeSessionOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeSessionConfigurationRemoteClient
implements KnowledgeSessionConfiguration,
Serializable {
    public static final String PROPERTY_MESSAGE_TIMEOUT = "grid.ksession.message.timeout";
    public static final String PROPERTY_MESSAGE_MINIMUM_WAIT_TIME = "grid.ksession.message.min.wait";
    private static Logger logger = LoggerFactory.getLogger(KnowledgeSessionConfigurationRemoteClient.class);
    private String instanceId;
    private GridServiceDescription<GridNode> gsd;
    private Grid grid;

    KnowledgeSessionConfigurationRemoteClient(String instanceId, Grid grid, GridServiceDescription<GridNode> gsd) {
        this.instanceId = instanceId;
        this.gsd = gsd;
        this.grid = grid;
    }

    public void setProperty(String name, String value) {
        logger.info("This InstanceId (KSessionConfRemoteClient) = " + this.instanceId);
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeSessionConfigurationRemoteCommands.SetPropertyRemoteCommand(this.instanceId, name, value)));
        ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public String getProperty(String name) {
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeSessionConfigurationRemoteCommands.GetPropertyRemoteCommand(this.instanceId, name)));
        return (String)ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public String getId() {
        return this.instanceId;
    }

    public void setId(String instanceId) {
        this.instanceId = instanceId;
    }

    public <T extends KnowledgeSessionOption> void setOption(T option) {
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeSessionConfigurationRemoteCommands.SetOptionRemoteCommand(this.instanceId, option)));
        ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public <T extends SingleValueKnowledgeSessionOption> T getOption(Class<T> option) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends MultiValueKnowledgeSessionOption> T getOption(Class<T> option, String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

