/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import org.drools.command.Command;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.QueryResultsRowRemoteClient;
import org.drools.grid.remote.command.HasNextQueryResultsRowRemoteCommand;
import org.drools.grid.remote.command.NextQueryResultsRowRemoteCommand;
import org.drools.runtime.rule.QueryResultsRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultsRowIteratorRemoteClient
implements Iterator<QueryResultsRow> {
    private String queryName;
    private String localId;
    private GridServiceDescription<GridNode> gsd;
    private String instanceId;
    private ConversationManager cm;

    public QueryResultsRowIteratorRemoteClient(String queryName, String localId, String instanceId, GridServiceDescription gsd, ConversationManager cm) {
        this.queryName = queryName;
        this.localId = localId;
        this.cm = cm;
        this.gsd = gsd;
        this.instanceId = instanceId;
    }

    @Override
    public boolean hasNext() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new HasNextQueryResultsRowRemoteCommand(this.queryName, this.localId), null, null, this.instanceId, kresultsId)));
        Boolean result = (Boolean)ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return result;
    }

    @Override
    public QueryResultsRow next() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new NextQueryResultsRowRemoteCommand(this.queryName, this.localId), null, null, this.instanceId, kresultsId)));
        String rowId = (String)ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return new QueryResultsRowRemoteClient(rowId, this.queryName, this.localId, this.instanceId, this.gsd, this.cm);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

