/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.drools.grid.CoreServicesLookup;
import org.drools.grid.Grid;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.internal.responsehandlers.BlockingMessageResponseHandler;
import org.drools.grid.io.Conversation;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.GridServiceDescriptionClient;
import org.drools.grid.service.directory.impl.WhitePagesImpl;
import org.drools.grid.service.directory.impl.WhitePagesServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhitePagesClient
implements WhitePages,
MessageReceiverHandlerFactoryService {
    private Grid grid;

    public WhitePagesClient(Grid grid) {
        this.grid = grid;
    }

    public GridServiceDescription<WhitePages> getGsd() {
        return this.grid.get(CoreServicesLookup.class).lookup(WhitePages.class);
    }

    public static Object sendMessage(ConversationManager conversationManager, Serializable addr, String id, Object body) {
        InetSocketAddress[] sockets = null;
        if (addr instanceof InetSocketAddress[]) {
            sockets = (InetSocketAddress[])addr;
        } else if (addr instanceof InetSocketAddress) {
            sockets = new InetSocketAddress[]{(InetSocketAddress)addr};
        }
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        Exception exception = null;
        Conversation conv = null;
        for (InetSocketAddress socket : sockets) {
            block12: {
                try {
                    conv = conversationManager.startConversation("", socket, id);
                    conv.sendMessage(body, handler);
                    exception = null;
                }
                catch (Exception e) {
                    exception = e;
                    if (conv == null) break block12;
                    conv.endConversation();
                }
            }
            if (exception == null) break;
        }
        if (exception != null) {
            throw new RuntimeException("Unable to send message", exception);
        }
        try {
            Object object = handler.getMessage().getBody();
            return object;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            conv.endConversation();
        }
    }

    @Override
    public GridServiceDescription create(String serviceDescriptionId, String ownerId) {
        GridServiceDescription<WhitePages> wpGsd = this.getGsd();
        InetSocketAddress[] sockets = (InetSocketAddress[])wpGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("WhitePages.create", Arrays.asList(serviceDescriptionId, ownerId));
        ConversationManager convm = this.grid.get(ConversationManager.class);
        GridServiceDescription gsd = (GridServiceDescription)WhitePagesClient.sendMessage(convm, (Serializable)sockets, wpGsd.getId(), cmd);
        return new GridServiceDescriptionClient(gsd, wpGsd, convm);
    }

    @Override
    public GridServiceDescription lookup(String serviceDescriptionId) {
        GridServiceDescription<WhitePages> wpGsd = this.getGsd();
        InetSocketAddress[] sockets = (InetSocketAddress[])wpGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("WhitePages.lookup", Arrays.asList(serviceDescriptionId));
        ConversationManager convm = this.grid.get(ConversationManager.class);
        GridServiceDescription gsd = (GridServiceDescription)WhitePagesClient.sendMessage(convm, (Serializable)sockets, wpGsd.getId(), cmd);
        return gsd == null ? gsd : new GridServiceDescriptionClient(gsd, wpGsd, convm);
    }

    @Override
    public void remove(String serviceDescriptionId) {
        GridServiceDescription<WhitePages> wpGsd = this.getGsd();
        InetSocketAddress[] sockets = (InetSocketAddress[])wpGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("WhitePages.remove", Arrays.asList(serviceDescriptionId));
        ConversationManager convm = this.grid.get(ConversationManager.class);
        WhitePagesClient.sendMessage(convm, (Serializable)sockets, wpGsd.getId(), cmd);
    }

    @Override
    public MessageReceiverHandler getMessageReceiverHandler() {
        return new WhitePagesServer(this);
    }

    @Override
    public void registerSocketService(Grid grid, String id, String ip, int port) {
        WhitePagesImpl.doRegisterSocketService(grid, id, ip, port);
    }
}

