/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.timer.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.drools.grid.timer.impl.ScheduledJobConfiguration;
import org.drools.grid.timer.impl.UuidJobHandle;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.Trigger;

public class ScheduledJob
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private String jobId;
    private UuidJobHandle jobHandle;
    private Class jobClass;
    private Serializable jobtrigger;
    private Date nextFireTime;
    private ScheduledJobConfiguration configuration;
    private Serializable ctx;

    public ScheduledJob() {
    }

    public ScheduledJob(UuidJobHandle jobHandle, Job job, JobContext context, Trigger trigger) {
        this.jobHandle = jobHandle;
        this.jobId = jobHandle.getUuid().toString();
        this.jobClass = job.getClass();
        this.ctx = context;
        this.jobtrigger = trigger;
        this.nextFireTime = trigger.hasNextFireTime();
    }

    public ScheduledJob(UuidJobHandle jobHandle, Job job, JobContext context, Trigger trigger, ScheduledJobConfiguration conf) {
        this(jobHandle, job, context, trigger);
        this.configuration = conf;
    }

    public JobHandle getJobHandle() {
        if (this.jobHandle == null) {
            this.jobHandle = new UuidJobHandle(UUID.fromString(this.jobId));
        }
        return this.jobHandle;
    }

    public Job getJob() {
        try {
            return (Job)this.jobClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getId() {
        return this.jobId;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Trigger getTrigger() {
        return (Trigger)this.jobtrigger;
    }

    public JobContext getJobContext() {
        return (JobContext)this.ctx;
    }

    public ScheduledJobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ScheduledJobConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return "ScheduledJob( job=" + this.jobClass.getName() + " trigger=" + this.jobtrigger + " context=" + this.ctx + " )";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.jobId);
        out.writeUTF(this.jobClass.getCanonicalName());
        out.writeObject(this.jobtrigger);
        out.writeLong(this.nextFireTime.getTime());
        out.writeObject(this.ctx);
        out.writeObject(this.configuration);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = in.readUTF();
        this.jobClass = Class.forName(in.readUTF());
        this.jobtrigger = (Serializable)in.readObject();
        this.nextFireTime = new Date(in.readLong());
        this.ctx = (Serializable)in.readObject();
        this.configuration = (ScheduledJobConfiguration)in.readObject();
    }
}

