/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.timer.impl;

import java.net.InetSocketAddress;
import org.drools.grid.CoreServicesLookup;
import org.drools.grid.Grid;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.CoreServicesLookupImpl;
import org.drools.grid.service.directory.impl.GridServiceDescriptionImpl;
import org.drools.grid.timer.impl.SchedulerServer;
import org.drools.grid.timer.impl.SchedulerServiceConfiguration;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SchedulerService;
import org.drools.time.TimerService;
import org.drools.time.Trigger;
import org.drools.time.impl.JDKTimerService;

public class SchedulerImpl
implements SchedulerService,
MessageReceiverHandlerFactoryService {
    private TimerService timer = new JDKTimerService();
    private String id;

    public SchedulerImpl(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        return this.timer.scheduleJob(job, ctx, trigger);
    }

    public boolean removeJob(JobHandle jobHandle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageReceiverHandler getMessageReceiverHandler() {
        return new SchedulerServer(this);
    }

    public void registerSocketService(Grid grid, String id, String ip, int port) {
        GridServiceDescription service;
        CoreServicesLookupImpl coreServicesWP = (CoreServicesLookupImpl)grid.get(CoreServicesLookup.class);
        GridServiceDescriptionImpl gsd = (GridServiceDescriptionImpl)coreServicesWP.lookup(SchedulerService.class);
        if (gsd == null) {
            gsd = new GridServiceDescriptionImpl(WhitePages.class, grid.getId());
        }
        if ((service = coreServicesWP.getServices().get(SchedulerService.class.getName())) == null) {
            coreServicesWP.getServices().put(SchedulerService.class.getName(), gsd);
            service = gsd;
        }
        Address address = null;
        address = service.getAddresses().get("socket") != null ? service.getAddresses().get("socket") : service.addAddress("socket");
        InetSocketAddress[] addresses = (InetSocketAddress[])address.getObject();
        if (addresses != null && addresses.length >= 1) {
            InetSocketAddress[] newAddresses = new InetSocketAddress[addresses.length + 1];
            if (addresses != null) {
                System.arraycopy(addresses, 0, newAddresses, 0, addresses.length);
            }
            newAddresses[addresses.length] = new InetSocketAddress(ip, port);
            SchedulerServiceConfiguration conf = new SchedulerServiceConfiguration(newAddresses);
            service.setData(conf);
        } else {
            InetSocketAddress[] newAddress = new InetSocketAddress[]{new InetSocketAddress(ip, port)};
            address.setObject(newAddress);
            SchedulerServiceConfiguration conf = new SchedulerServiceConfiguration(newAddress);
            service.setData(conf);
        }
    }
}

