/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.converter.stream.SourceCache;
import org.apache.camel.converter.stream.StreamSourceCache;
import org.apache.camel.util.IOHelper;

@Converter
public class StreamCacheConverter {
    @Converter
    public StreamCache convertToStreamCache(StreamSource source, Exchange exchange) throws IOException {
        return new StreamSourceCache(source, exchange);
    }

    @Converter
    public StreamCache convertToStreamCache(StringSource source) {
        return null;
    }

    @Converter
    public StreamCache convertToStreamCache(BytesSource source) {
        return null;
    }

    @Converter
    public StreamCache convertToStreamCache(SAXSource source, Exchange exchange) throws TransformerException {
        String data = exchange.getContext().getTypeConverter().convertTo(String.class, source);
        return new SourceCache(data);
    }

    @Converter
    public StreamCache convertToStreamCache(InputStream stream, Exchange exchange) throws IOException {
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput(stream, cos);
        return cos.getStreamCache();
    }

    @Converter
    public StreamCache convertToStreamCache(Reader reader, Exchange exchange) throws IOException {
        String data = exchange.getContext().getTypeConverter().convertTo(String.class, reader);
        return new ReaderCache(data);
    }

    @Converter
    public Serializable convertToSerializable(StreamCache cache, Exchange exchange) throws IOException {
        byte[] data = this.convertToByteArray(cache, exchange);
        return new BytesSource(data);
    }

    @Converter
    public byte[] convertToByteArray(StreamCache cache, Exchange exchange) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        cache.writeTo(os);
        return os.toByteArray();
    }
}

