/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionTemplate {
    private static final Log LOG = LogFactory.getLog(TransactionTemplate.class);
    private PersistenceAdapter persistenceAdapter;
    private ConnectionContext context;

    public TransactionTemplate(PersistenceAdapter persistenceAdapter, ConnectionContext context) {
        this.persistenceAdapter = persistenceAdapter;
        this.context = context;
    }

    public void run(Callback task) throws IOException {
        this.persistenceAdapter.beginTransaction(this.context);
        Throwable throwable = null;
        try {
            task.execute();
        }
        catch (IOException t) {
            throwable = t;
            throw t;
        }
        catch (RuntimeException t) {
            throwable = t;
            throw t;
        }
        catch (Throwable t) {
            throwable = t;
            throw IOExceptionSupport.create("Persistence task failed: " + t, t);
        }
        finally {
            if (throwable == null) {
                this.persistenceAdapter.commitTransaction(this.context);
            } else {
                LOG.error((Object)("Having to Rollback - caught an exception: " + throwable));
                this.persistenceAdapter.rollbackTransaction(this.context);
            }
        }
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }
}

