/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public final class DataHolder {
    final ByteBuffer buffer;
    final int size;

    public DataHolder(int size) {
        this.size = size;
        this.buffer = ByteBuffer.allocate(size);
    }

    public DataHolder(Data data) {
        this.size = data.size();
        this.buffer = ByteBuffer.wrap(data.buffer);
    }

    public boolean shouldRead() {
        return this.size > 0 && this.buffer != null && this.buffer.hasRemaining();
    }

    public void read(ByteBuffer src) {
        IOUtil.copyToHeapBuffer(src, this.buffer);
    }

    public int size() {
        return this.size;
    }

    public void postRead() {
        if (this.size > 0) {
            this.buffer.flip();
        }
    }

    public Data toData() {
        return new Data(this.buffer.array());
    }
}

