/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker;

import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.drools.examples.broker.Broker;
import org.drools.examples.broker.events.EventFeeder;
import org.drools.examples.broker.events.StockTickPersister;
import org.drools.examples.broker.model.CompanyRegistry;
import org.drools.examples.broker.ui.BrokerWindow;
import org.drools.time.impl.JDKTimerService;

public class BrokerExample {
    public static void main(String[] args) {
        new BrokerExample().init(true);
    }

    public void init(boolean exitOnClose) {
        Locale.setDefault(Locale.US);
        CompanyRegistry registry = new CompanyRegistry();
        BrokerWindow window = new BrokerWindow(registry.getCompanies(), exitOnClose);
        window.show();
        Broker broker = new Broker(window, registry);
        JDKTimerService clock = new JDKTimerService(1);
        StockTickPersister source = new StockTickPersister();
        try {
            source.openForRead(new InputStreamReader(BrokerExample.class.getResourceAsStream("/org/drools/examples/broker/data/stocktickstream.dat")), System.currentTimeMillis());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not read data file.", e);
        }
        EventFeeder feeder = new EventFeeder(clock, source, broker);
        feeder.feed();
    }
}

