/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventImpl;
import org.drools.examples.broker.events.EventSource;
import org.drools.examples.broker.model.StockTick;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StockTickPersister
implements EventSource {
    private MessageFormat format = new MessageFormat("{0,number,0};{1};{2,number,currency}");
    private BufferedWriter out;
    private BufferedReader in;
    private long baseTimestamp;
    private Event<StockTick> next;

    public void openForSave(Writer writer) throws IOException {
        this.out = new BufferedWriter(writer);
    }

    public void openForRead(Reader reader, long baseTimestamp) throws FileNotFoundException {
        this.in = new BufferedReader(reader);
        this.baseTimestamp = baseTimestamp;
    }

    public void save(StockTick tick) throws IOException {
        Object[] args = new Object[]{tick.getTimestamp(), tick.getSymbol(), tick.getPrice()};
        this.out.append(this.format.format(args) + "\n");
    }

    public StockTick load() throws ParseException, IOException {
        String line = this.in.readLine();
        if (line == null) {
            System.out.println("End of file");
            return null;
        }
        Object[] results = this.format.parse(line);
        StockTick tick = new StockTick((String)results[1], ((Number)results[2]).doubleValue(), ((Number)results[0]).longValue() + this.baseTimestamp);
        return tick;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
    }

    public Event<StockTick> getNext() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        if (this.in != null) {
            try {
                StockTick tick = this.load();
                if (tick == null) {
                    return false;
                }
                this.next = new EventImpl<StockTick>(tick.getTimestamp(), tick);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

