/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

class ClientMessageObserver
implements MessageObserver {
    private ClientConfiguration cfg;
    private ClassLoader loader;

    public ClientMessageObserver(ClientConfiguration cfg) {
        this.cfg = cfg;
        this.loader = cfg.getBus().getExtension(ClassLoader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        Message message = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage(m);
        message.put("org.apache.cxf.client", Boolean.TRUE);
        message.put("org.apache.cxf.message.inbound", Boolean.TRUE);
        PhaseInterceptorChain chain = AbstractClient.setupInInterceptorChain(this.cfg);
        message.setInterceptorChain(chain);
        message.getExchange().setInMessage(message);
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.cfg.getBus());
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.loader != null) {
                Thread.currentThread().setContextClassLoader(this.loader);
            }
            chain.doIntercept(message);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            BusFactory.setThreadDefaultBus(origBus);
            Thread.currentThread().setContextClassLoader(origLoader);
            throw throwable;
        }
        BusFactory.setThreadDefaultBus(origBus);
        Thread.currentThread().setContextClassLoader(origLoader);
    }
}

