/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import java.util.EmptyStackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.cdr.extension.ResourceConfigUtil;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

public class MapToResourceConfigFromAttribute
implements DOMVisitBefore {
    private static Log logger = LogFactory.getLog(MapToResourceConfigFromAttribute.class);
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String mapTo;
    @ConfigParam
    private String attribute;
    @ConfigParam(defaultVal="##NULL")
    private String defaultValue;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration config;
        String value = DomUtils.getAttributeValue(element, this.attribute);
        String actualMapTo = this.mapTo;
        if (actualMapTo == null) {
            actualMapTo = this.attribute;
        }
        try {
            config = ExtensionContext.getExtensionContext(executionContext).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No SmooksResourceConfiguration available in ExtensionContext stack.  Unable to set SmooksResourceConfiguration property '" + actualMapTo + "' with attribute '" + this.attribute + "' value '" + value + "'.");
        }
        if (value == null) {
            value = this.defaultValue;
        }
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not setting property '" + actualMapTo + "' on resource configuration.  Attribute '" + this.attribute + "' value on element '" + DomUtils.getName(element) + "' is null.  You may need to set a default value in the binding configuration."));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting property '" + actualMapTo + "' on resource configuration to a value of '" + value + "'."));
        }
        ResourceConfigUtil.setProperty(config, actualMapTo, value, executionContext);
    }
}

