/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;

public class ExecutionLifecycleCleanableList {
    private static Log logger = LogFactory.getLog(ExecutionLifecycleCleanableList.class);
    private ExecutionContext executionContext;
    private List<ExecutionLifecycleCleanable> lifecycleCleanables = new ArrayList<ExecutionLifecycleCleanable>();

    public ExecutionLifecycleCleanableList(ExecutionContext executionContext) {
        AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
        this.executionContext = executionContext;
    }

    public void add(ExecutionLifecycleCleanable cleanable) {
        this.lifecycleCleanables.remove(cleanable);
        this.lifecycleCleanables.add(cleanable);
    }

    public void cleanup() {
        for (ExecutionLifecycleCleanable lifecycleCleanable : this.lifecycleCleanables) {
            try {
                lifecycleCleanable.executeExecutionLifecycleCleanup(this.executionContext);
            }
            catch (Throwable t) {
                logger.error((Object)("Cleanup failure: " + lifecycleCleanable.getClass().getName()), t);
            }
        }
    }
}

