/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.repository;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaResult;
import org.milyn.payload.JavaSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRepositoryManager {
    private static final String CONTEXT_KEY = BeanRepositoryManager.class.getName() + "#CONTEXT_KEY";
    private static final String BEAN_REPOSITORY_CONTEXT_KEY = BeanRepository.class.getName() + "#CONTEXT_KEY";
    private final BeanIdRegister beanIdRegister = new BeanIdRegister();

    public static BeanRepositoryManager getInstance(ApplicationContext applicationContext) {
        BeanRepositoryManager beanRepositoryManager = (BeanRepositoryManager)applicationContext.getAttribute((Object)CONTEXT_KEY);
        if (beanRepositoryManager == null) {
            beanRepositoryManager = new BeanRepositoryManager();
            applicationContext.setAttribute((Object)CONTEXT_KEY, (Object)beanRepositoryManager);
        }
        return beanRepositoryManager;
    }

    private BeanRepositoryManager() {
    }

    public BeanIdRegister getBeanIdRegister() {
        return this.beanIdRegister;
    }

    public static BeanRepository getBeanRepository(ExecutionContext executionContext) {
        BeanRepository beanRepository = (BeanRepository)executionContext.getAttribute((Object)BEAN_REPOSITORY_CONTEXT_KEY);
        if (beanRepository == null) {
            beanRepository = BeanRepositoryManager.getInstance(executionContext.getContext()).createBeanRepository(executionContext);
            executionContext.setAttribute((Object)BEAN_REPOSITORY_CONTEXT_KEY, (Object)beanRepository);
        }
        return beanRepository;
    }

    private BeanRepository createBeanRepository(ExecutionContext executionContext) {
        Map<String, Object> beanMap = this.createBeanMap(executionContext);
        BeanRepository beanRepository = new BeanRepository(executionContext, this.beanIdRegister, beanMap);
        return beanRepository;
    }

    private Map<String, Object> createBeanMap(ExecutionContext executionContext) {
        JavaSource javaSource;
        Map sourceBeans;
        Result result = FilterResult.getResult((ExecutionContext)executionContext, JavaResult.class);
        Source source = FilterSource.getSource((ExecutionContext)executionContext);
        Map<String, Object> beanMap = null;
        if (result != null) {
            JavaResult javaResult = (JavaResult)result;
            beanMap = javaResult.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (this.beanIdRegister.containsBeanId(beanId)) continue;
                this.beanIdRegister.register(beanId);
            }
        }
        return beanMap;
    }
}

