/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.grid.ConnectionFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridConnection;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.SocketService;
import org.drools.grid.conf.GridPeerServiceConfiguration;
import org.drools.grid.impl.ConnectionFactoryServiceImpl;
import org.drools.grid.impl.GridNodeImpl;
import org.drools.grid.io.AcceptorFactoryService;
import org.drools.grid.io.ConnectorFactoryService;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.ConversationManagerImpl;
import org.drools.grid.remote.GridNodeRemoteClient;
import org.drools.grid.remote.mina.MinaAcceptorFactoryService;
import org.drools.grid.remote.mina.MinaConnectorFactoryService;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.WhitePagesRemoteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridImpl
implements Grid {
    private String id;
    private Map<String, Object> services;
    private Map<String, GridNode> localNodes = new HashMap<String, GridNode>();
    private Map<String, GridPeerServiceConfiguration> serviceConfigurators = new HashMap<String, GridPeerServiceConfiguration>();
    private static Logger logger = LoggerFactory.getLogger(GridImpl.class);

    public GridImpl() {
        this(UUID.randomUUID().toString(), null);
    }

    public GridImpl(String id) {
        this(id, null);
    }

    public GridImpl(Map<String, Object> services) {
        this(UUID.randomUUID().toString(), services);
    }

    public GridImpl(String id, Map<String, Object> services) {
        this.services = services == null ? new ConcurrentHashMap<String, Object>() : services;
        this.id = id;
        this.init();
    }

    private void init() {
        SystemEventListener listener = SystemEventListenerFactory.getSystemEventListener();
        this.addService(SystemEventListener.class, (Object)listener);
        this.addService(AcceptorFactoryService.class, (Object)new MinaAcceptorFactoryService());
        this.addService(ConnectorFactoryService.class, (Object)new MinaConnectorFactoryService());
        this.addService(ConversationManager.class, (Object)new ConversationManagerImpl(this, listener));
        this.addService(ConnectionFactoryService.class.getName(), (Object)new ConnectionFactoryServiceImpl(this));
        this.serviceConfigurators.put(WhitePages.class.getName(), new WhitePagesRemoteConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (logger.isInfoEnabled()) {
            logger.info(" Shutting down GRID! " + this.id);
        }
        try {
            WhitePages wp = this.get(WhitePages.class, false);
            if (wp != null) {
                for (String nodeId : this.localNodes.keySet()) {
                    GridNode node = this.localNodes.get(nodeId);
                    if (!node.isLocalProxy()) {
                        wp.remove(nodeId);
                    }
                    node.dispose();
                }
            }
        }
        catch (Throwable t) {
            logger.error(" Grid couldn't unregister all local nodes " + t.getMessage(), t);
        }
        finally {
            SocketService socketService = this.get(SocketService.class);
            socketService.close();
        }
        if (logger.isInfoEnabled()) {
            logger.info(" GRID shut down ! " + this.id);
        }
    }

    public Object get(String str) {
        return this.services.get(str);
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        return this.get(serviceClass, false);
    }

    public <T> T get(Class<T> serviceClass, boolean lazyInit) {
        GridPeerServiceConfiguration configurator;
        Object service = this.services.get(serviceClass.getName());
        if (lazyInit && service == null && (configurator = this.serviceConfigurators.get(serviceClass.getName())) != null) {
            configurator.configureService(this);
            service = this.services.get(serviceClass.getName());
        }
        return (T)service;
    }

    public void addService(Class cls, Object service) {
        this.addService(cls.getName(), service);
    }

    public void addService(String id, Object service) {
        this.services.put(id, service);
    }

    @Override
    public GridNode createGridNode(String id) {
        if (logger.isDebugEnabled()) {
            logger.debug(" ### GridImpl: Registering in white pages (grid = " + this.getId() + ") new node = " + id);
        }
        WhitePages wp = this.get(WhitePages.class);
        GridServiceDescription gsd = wp.create(id, this.id);
        gsd.setServiceInterface(GridNode.class);
        GridNodeImpl node = new GridNodeImpl(id);
        this.localNodes.put(id, node);
        return node;
    }

    @Override
    public GridNode claimGridNode(String id) {
        if (logger.isDebugEnabled()) {
            logger.debug(" ### GridImpl: Claiming orphan node " + id + " found in white pages (grid = " + this.getId() + ") ");
        }
        WhitePages wp = this.get(WhitePages.class);
        wp.remove(id);
        GridServiceDescription gsd = wp.create(id, this.id);
        gsd.setServiceInterface(GridNode.class);
        GridNodeImpl node = new GridNodeImpl(id);
        this.localNodes.put(id, node);
        return node;
    }

    @Override
    public void removeGridNode(String id) {
        WhitePages wp = this.get(WhitePages.class);
        wp.remove(id);
        this.localNodes.remove(id);
    }

    @Override
    public GridNode getGridNode(String id) {
        return this.localNodes.get(id);
    }

    @Override
    public GridNode asRemoteNode(GridNode node) {
        if (node.isRemote()) {
            return node;
        }
        GridServiceDescription nGsd = this.get(WhitePages.class).lookup(node.getId());
        ConnectionFactoryService cfs = this.get(ConnectionFactoryService.class);
        boolean allowsLocal = cfs.isLocalAllowed();
        cfs.setLocalAllowed(false);
        GridConnection conn = cfs.createConnection(nGsd);
        if (logger.isDebugEnabled()) {
            logger.debug("  ### Session Manager: Opened connection to node: " + conn);
        }
        cfs.setLocalAllowed(allowsLocal);
        GridNodeRemoteClient rem = (GridNodeRemoteClient)conn.connect();
        rem.setLocalProxy(true);
        this.localNodes.put(node.getId() + "$$LocalProxy", rem);
        return rem;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

