/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.internal.commands;

import java.io.Serializable;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.RuleBaseConfiguration;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.conf.KnowledgeBaseOption;

public class KnowledgeBaseConfigurationRemoteCommands
implements Serializable {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetPropertyRemoteCommand
    implements GenericCommand<String> {
        private final String identifier;
        private final String propertyName;

        public GetPropertyRemoteCommand(String identifier, String propertyName) {
            this.identifier = identifier;
            this.propertyName = propertyName;
        }

        public String execute(Context context) {
            KnowledgeBaseConfiguration kconf = (KnowledgeBaseConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            return kconf.getProperty(this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetOptionRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;
        private final KnowledgeBaseOption option;

        public SetOptionRemoteCommand(String identifier, KnowledgeBaseOption option) {
            this.identifier = identifier;
            this.option = option;
        }

        public Void execute(Context context) {
            KnowledgeBaseConfiguration kconf = (KnowledgeBaseConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            kconf.setOption(this.option);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetPropertyRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;
        private final String propertyName;
        private final String propertyValue;

        public SetPropertyRemoteCommand(String identifier, String propertyName, String propertyValue) {
            this.identifier = identifier;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public Void execute(Context context) {
            KnowledgeBaseConfiguration kconf = (KnowledgeBaseConfiguration)context.getContextManager().getContext("__TEMP__").get(this.identifier);
            kconf.setProperty(this.propertyName, this.propertyValue);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewKnowledgeBaseConfigurationRemoteCommand
    implements GenericCommand<Void> {
        private final String identifier;

        public NewKnowledgeBaseConfigurationRemoteCommand(String identifier) {
            this.identifier = identifier;
        }

        public Void execute(Context context) {
            context.getContextManager().getContext("__TEMP__").set(this.identifier, (Object)new GridKnowledgeBaseConfiguration());
            return null;
        }
    }

    private static class GridKnowledgeBaseConfiguration
    extends RuleBaseConfiguration {
        private String messageTimeout;
        private String messageMinWaitTime;

        private GridKnowledgeBaseConfiguration() {
        }

        public void setProperty(String name, String value) {
            if (name.equals("grid.kbase.message.timeout")) {
                this.messageTimeout = value;
            } else if (name.equals("grid.kbase.message.min.wait")) {
                this.messageMinWaitTime = value;
            } else {
                super.setProperty(name, value);
            }
        }

        public String getProperty(String name) {
            if (name.equals("grid.kbase.message.timeout")) {
                return this.messageTimeout;
            }
            if (name.equals("grid.kbase.message.min.wait")) {
                return this.messageMinWaitTime;
            }
            return super.getProperty(name);
        }
    }
}

