/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.internal.responsehandlers;

import org.drools.grid.TimeoutException;
import org.drools.grid.internal.responsehandlers.AbstractBaseResponseHandler;
import org.drools.grid.io.Conversation;
import org.drools.grid.io.Message;

public class BlockingMessageResponseHandler
extends AbstractBaseResponseHandler {
    private long timeout = 6000L;
    public long initialWaitTime = 50L;
    private volatile Message message;

    public void messageReceived(Conversation conversation, Message message) {
        this.message = message;
        this.setDone(true);
    }

    public Message getMessage() throws RuntimeException, TimeoutException {
        return this.getMessage(this.initialWaitTime, this.timeout);
    }

    public Message getMessage(long initialWaitTime, long timeout) throws RuntimeException, TimeoutException {
        return this.waitForResponse(initialWaitTime, timeout);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setInitialWaitTime(long initialWaitTime) {
        this.initialWaitTime = initialWaitTime;
    }

    private synchronized Message waitForResponse(long initialWaitTime, long timeout) throws RuntimeException, TimeoutException {
        long waitTime = initialWaitTime;
        while (!this.isDone() && !this.hasError() && waitTime < timeout) {
            try {
                this.wait(waitTime);
                waitTime *= 2L;
            }
            catch (InterruptedException e) {}
        }
        if (this.hasError()) {
            throw new RuntimeException(this.getError());
        }
        if (this.isDone()) {
            return this.message;
        }
        throw new TimeoutException("Timeout waiting for responses ");
    }
}

