/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.command.Command;
import org.drools.command.SetVariableCommandFromCommand;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.internal.commands.KnowledgeBaseConfigurationRemoteCommands;
import org.drools.grid.internal.commands.KnowledgeSessionConfigurationRemoteCommands;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.KnowledgeBaseConfigurationRemoteClient;
import org.drools.grid.remote.KnowledgeBaseRemoteClient;
import org.drools.grid.remote.KnowledgeSessionConfigurationRemoteClient;
import org.drools.grid.remote.NewKnowledgeBaseRemoteCommand;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseProviderRemoteClient
implements KnowledgeBaseFactoryService {
    private static Logger logger = LoggerFactory.getLogger(KnowledgeBaseProviderRemoteClient.class);
    private Grid grid;
    private GridServiceDescription<GridNode> gsd;

    public KnowledgeBaseProviderRemoteClient(Grid grid, GridServiceDescription gsd) {
        this.grid = grid;
        this.gsd = gsd;
    }

    public KnowledgeBaseConfiguration newKnowledgeBaseConfiguration() {
        String localId = UUID.randomUUID().toString();
        logger.info("This InstanceId (just generated) = " + localId);
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeBaseConfigurationRemoteCommands.NewKnowledgeBaseConfigurationRemoteCommand(localId)));
        ConversationManager connm = this.grid.get(ConversationManager.class);
        ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return new KnowledgeBaseConfigurationRemoteClient(localId, this.grid, this.gsd);
    }

    public KnowledgeBaseConfiguration newKnowledgeBaseConfiguration(Properties properties, ClassLoader ... classLoader) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KnowledgeSessionConfiguration newKnowledgeSessionConfiguration() {
        String localId = UUID.randomUUID().toString();
        logger.info("This InstanceId (just generated) = " + localId);
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeSessionConfigurationRemoteCommands.NewKnowledgeSessionConfigurationRemoteCommand(localId)));
        ConversationManager connm = this.grid.get(ConversationManager.class);
        ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return new KnowledgeSessionConfigurationRemoteClient(localId, this.grid, this.gsd);
    }

    public KnowledgeSessionConfiguration newKnowledgeSessionConfiguration(Properties properties) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KnowledgeBase newKnowledgeBase() {
        return this.newKnowledgeBase("", null);
    }

    public KnowledgeBase newKnowledgeBase(String kbaseId) {
        return this.newKnowledgeBase(kbaseId, null);
    }

    public KnowledgeBase newKnowledgeBase(KnowledgeBaseConfiguration conf) {
        return this.newKnowledgeBase(null, conf);
    }

    public KnowledgeBase newKnowledgeBase(String kbaseId, KnowledgeBaseConfiguration conf) {
        String localId = "";
        localId = kbaseId == null || kbaseId.equals("") ? UUID.randomUUID().toString() : kbaseId;
        String kbaseConfId = ((KnowledgeBaseConfigurationRemoteClient)conf).getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new SetVariableCommandFromCommand("__TEMP__", localId, (Command)new NewKnowledgeBaseRemoteCommand(kbaseConfId))));
        ConversationManager connm = this.grid.get(ConversationManager.class);
        ConversationUtil.sendMessage(connm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return new KnowledgeBaseRemoteClient(localId, this.gsd, connm, (KnowledgeBaseConfigurationRemoteClient)conf);
    }

    public Environment newEnvironment() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

