/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.drools.KnowledgeBase;
import org.drools.builder.CompositeKnowledgeBuilder;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderResults;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.builder.ResultSeverity;
import org.drools.command.Command;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.builder.KnowledgeBuilderAddCommand;
import org.drools.command.builder.KnowledgeBuilderGetErrorsCommand;
import org.drools.definition.KnowledgePackage;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CollectionClient;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.KnowledgeBuilderConfigurationRemoteClient;
import org.drools.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBuilderRemoteClient
implements KnowledgeBuilder {
    private String instanceId;
    private ConversationManager cm;
    private GridServiceDescription<GridNode> gsd;
    private KnowledgeBuilderConfigurationRemoteClient conf;
    private Long timeout;
    private Long minWaitTime;

    public KnowledgeBuilderRemoteClient(String localId, GridServiceDescription gsd, ConversationManager cm, KnowledgeBuilderConfigurationRemoteClient conf) {
        this.instanceId = localId;
        this.gsd = gsd;
        this.cm = cm;
        this.conf = conf;
        if (this.conf != null) {
            String configuredMinWaitTime;
            String configuredTimeout = this.conf.getProperty("grid.kbuilder.message.timeout");
            if (configuredTimeout != null) {
                this.timeout = Long.parseLong(configuredTimeout);
            }
            if ((configuredMinWaitTime = this.conf.getProperty("grid.kbuilder.message.min.wait")) != null) {
                this.minWaitTime = Long.parseLong(configuredMinWaitTime);
            }
        }
    }

    public void add(Resource resource, ResourceType type) {
        this.add(resource, type, null);
    }

    public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        String localId = UUID.randomUUID().toString();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBuilderAddCommand(resource, type, configuration), this.instanceId, null, null, null)));
        this.sendMessage(cmd);
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        return new CollectionClient(this.instanceId);
    }

    public KnowledgeBase newKnowledgeBase() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasErrors() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KnowledgeBuilderErrors getErrors() {
        String commandId = "kbuilder.getErrors_" + this.gsd.getId();
        String kresultsId = "kresults_" + this.gsd.getId();
        String localId = UUID.randomUUID().toString();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBuilderGetErrorsCommand(), this.instanceId, null, null, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (KnowledgeBuilderErrors)result;
    }

    private Object sendMessage(Object body) {
        return ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), body, this.minWaitTime, this.timeout);
    }

    public KnowledgeBuilderResults getResults(ResultSeverity ... severities) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasResults(ResultSeverity ... severities) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void undo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompositeKnowledgeBuilder batch() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

