/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldWriter;
import org.drools.base.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFloatClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseFloatClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseFloatClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setFloatValue(bean, value == null ? 0.0f : ((Number)value).floatValue());
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeDroolsException("Conversion to float not supported from boolean");
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.setFloatValue(bean, value);
    }

    @Override
    public void setCharValue(Object bean, char value) {
        throw new RuntimeDroolsException("Conversion to float not supported from char");
    }

    @Override
    public void setDoubleValue(Object bean, double value) {
        this.setFloatValue(bean, (float)value);
    }

    @Override
    public abstract void setFloatValue(Object var1, float var2);

    @Override
    public void setIntValue(Object bean, int value) {
        this.setFloatValue(bean, value);
    }

    @Override
    public void setLongValue(Object bean, long value) {
        this.setFloatValue(bean, value);
    }

    @Override
    public void setShortValue(Object bean, short value) {
        this.setFloatValue(bean, value);
    }

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setFloatValue", Object.class, Float.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

