/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LeftTupleIterator;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.reteoo.ConditionalBranchEvaluator;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.EvalNodeLeftTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class ConditionalBranchNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private LeftTupleSource tupleSource;
    private ConditionalBranchEvaluator branchEvaluator;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public ConditionalBranchNode() {
    }

    public ConditionalBranchNode(int id, LeftTupleSource tupleSource, ConditionalBranchEvaluator branchEvaluator, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.branchEvaluator = branchEvaluator;
        this.initMasks(context, tupleSource);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.branchEvaluator = (ConditionalBranchEvaluator)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.branchEvaluator);
    }

    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchMemory memory = (ConditionalBranchMemory)workingMemory.getNodeMemory(this);
        boolean breaking = false;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate(leftTuple, workingMemory, memory.context);
        if (conditionalExecution != null) {
            conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            breaking = conditionalExecution.isBreaking();
        }
        if (!breaking) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchMemory memory = (ConditionalBranchMemory)workingMemory.getNodeMemory(this);
        boolean wasPropagated = leftTuple.getFirstChild() != null;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate(leftTuple, workingMemory, memory.context);
        if (wasPropagated) {
            LeftTupleSink mainSink = this.sink.getSinks()[0];
            LeftTupleSink oldSink = leftTuple.getFirstChild().getSink();
            if (conditionalExecution != null) {
                LeftTupleSink newSink = conditionalExecution.getSink().getSinks()[0];
                if (oldSink.equals(newSink)) {
                    conditionalExecution.getSink().propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking()) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                } else {
                    if (oldSink.equals(mainSink)) {
                        if (conditionalExecution.isBreaking()) {
                            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                        } else {
                            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                        }
                    } else {
                        conditionalExecution.getSink().propagateRetractLeftTuple(leftTuple, context, workingMemory);
                    }
                    conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking() && !oldSink.equals(mainSink)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                }
            } else if (oldSink.equals(mainSink)) {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else {
            boolean breaking = false;
            if (conditionalExecution != null) {
                conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        }
    }

    public String toString() {
        return "[ConditionalBranchNode: cond=" + this.branchEvaluator + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.branchEvaluator.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        ConditionalBranchNode other = (ConditionalBranchNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.branchEvaluator.equals(other.branchEvaluator);
    }

    public Memory createMemory(RuleBaseConfiguration config) {
        return new ConditionalBranchMemory(this.branchEvaluator.createContext());
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory(this);
            }
        } else {
            throw new RuntimeException("ConditionalBranchNode cannot be shared");
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 20;
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.tupleSource.getObjectTypeNode();
    }

    public static class ConditionalBranchMemory
    implements Externalizable,
    Memory {
        private static final long serialVersionUID = 510L;
        public Object context;

        public ConditionalBranchMemory() {
        }

        public ConditionalBranchMemory(Object context) {
            this.context = context;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }

        public short getNodeType() {
            return 3;
        }
    }
}

