/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ExchangeHelper;

@ManagedResource(description="PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter,
ManagedPerformanceCounterMBean {
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic failuresHandled;
    private Statistic redeliveries;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private String firstExchangeCompletedExchangeId;
    private Statistic firstExchangeFailureTimestamp;
    private String firstExchangeFailureExchangeId;
    private Statistic lastExchangeCompletedTimestamp;
    private String lastExchangeCompletedExchangeId;
    private Statistic lastExchangeFailureTimestamp;
    private String lastExchangeFailureExchangeId;
    private boolean statisticsEnabled = true;

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = new Statistic("org.apache.camel.exchangesCompleted", this, Statistic.UpdateMode.COUNTER);
        this.exchangesFailed = new Statistic("org.apache.camel.exchangesFailed", this, Statistic.UpdateMode.COUNTER);
        this.failuresHandled = new Statistic("org.apache.camel.failuresHandled", this, Statistic.UpdateMode.COUNTER);
        this.redeliveries = new Statistic("org.apache.camel.redeliveries", this, Statistic.UpdateMode.COUNTER);
        this.minProcessingTime = new Statistic("org.apache.camel.minimumProcessingTime", this, Statistic.UpdateMode.MINIMUM);
        this.maxProcessingTime = new Statistic("org.apache.camel.maximumProcessingTime", this, Statistic.UpdateMode.MAXIMUM);
        this.totalProcessingTime = new Statistic("org.apache.camel.totalProcessingTime", this, Statistic.UpdateMode.COUNTER);
        this.lastProcessingTime = new Statistic("org.apache.camel.lastProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.meanProcessingTime = new Statistic("org.apache.camel.meanProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeCompletedTimestamp = new Statistic("org.apache.camel.firstExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeFailureTimestamp = new Statistic("org.apache.camel.firstExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeCompletedTimestamp = new Statistic("org.apache.camel.lastExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeFailureTimestamp = new Statistic("org.apache.camel.lastExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.failuresHandled.reset();
        this.redeliveries.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeCompletedExchangeId = null;
        this.firstExchangeFailureTimestamp.reset();
        this.firstExchangeFailureExchangeId = null;
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeCompletedExchangeId = null;
        this.lastExchangeFailureTimestamp.reset();
        this.lastExchangeFailureExchangeId = null;
    }

    @Override
    public long getExchangesCompleted() throws Exception {
        return this.exchangesCompleted.getValue();
    }

    @Override
    public long getExchangesFailed() throws Exception {
        return this.exchangesFailed.getValue();
    }

    @Override
    public long getFailuresHandled() throws Exception {
        return this.failuresHandled.getValue();
    }

    @Override
    public long getRedeliveries() throws Exception {
        return this.redeliveries.getValue();
    }

    @Override
    public long getMinProcessingTime() throws Exception {
        return this.minProcessingTime.getValue();
    }

    @Override
    public long getMeanProcessingTime() throws Exception {
        return this.meanProcessingTime.getValue();
    }

    @Override
    public long getMaxProcessingTime() throws Exception {
        return this.maxProcessingTime.getValue();
    }

    @Override
    public long getTotalProcessingTime() throws Exception {
        return this.totalProcessingTime.getValue();
    }

    @Override
    public long getLastProcessingTime() throws Exception {
        return this.lastProcessingTime.getValue();
    }

    @Override
    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getLastExchangeCompletedExchangeId() {
        return this.lastExchangeCompletedExchangeId;
    }

    @Override
    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getFirstExchangeCompletedExchangeId() {
        return this.firstExchangeCompletedExchangeId;
    }

    @Override
    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getLastExchangeFailureExchangeId() {
        return this.lastExchangeFailureExchangeId;
    }

    @Override
    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getFirstExchangeFailureExchangeId() {
        return this.firstExchangeFailureExchangeId;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public synchronized void completedExchange(Exchange exchange, long time) {
        this.increment();
        this.exchangesCompleted.increment();
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.failuresHandled.increment();
        }
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        long now = new Date().getTime();
        if (this.firstExchangeCompletedTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        if (this.firstExchangeCompletedExchangeId == null) {
            this.firstExchangeCompletedExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeCompletedExchangeId = exchange.getExchangeId();
        long count = this.exchangesCompleted.getValue();
        long mean = count > 0L ? this.totalProcessingTime.getValue() / count : 0L;
        this.meanProcessingTime.updateValue(mean);
    }

    @Override
    public synchronized void failedExchange(Exchange exchange) {
        this.increment();
        this.exchangesFailed.increment();
        if (ExchangeHelper.isRedelivered(exchange)) {
            this.redeliveries.increment();
        }
        long now = new Date().getTime();
        if (this.firstExchangeFailureTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
        if (this.firstExchangeFailureExchangeId == null) {
            this.firstExchangeFailureExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeFailureExchangeId = exchange.getExchangeId();
    }
}

