/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Endpoint;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.EndpointHelper;

@XmlRootElement(name="interceptToEndpoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptSendToEndpointDefinition
extends OutputDefinition<InterceptSendToEndpointDefinition> {
    @XmlAttribute(required=true)
    private String uri;
    @XmlAttribute
    private Boolean skipSendToOriginalEndpoint;

    public InterceptSendToEndpointDefinition() {
    }

    public InterceptSendToEndpointDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public String toString() {
        return "InterceptSendToEndpoint[" + this.uri + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "interceptSendToEndpoint";
    }

    @Override
    public String getLabel() {
        return "interceptSendToEndpoint[" + this.uri + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        final Processor detour = this.createChildProcessor(routeContext, true);
        routeContext.getCamelContext().addRegisterEndpointCallback(new EndpointStrategy(){

            @Override
            public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
                if (endpoint instanceof InterceptSendToEndpoint) {
                    return endpoint;
                }
                if (InterceptSendToEndpointDefinition.this.getUri() == null || EndpointHelper.matchEndpoint(uri, InterceptSendToEndpointDefinition.this.getUri())) {
                    boolean skip = InterceptSendToEndpointDefinition.this.getSkipSendToOriginalEndpoint() != null ? InterceptSendToEndpointDefinition.this.getSkipSendToOriginalEndpoint() : false;
                    InterceptSendToEndpoint proxy = new InterceptSendToEndpoint(endpoint, skip);
                    proxy.setDetour(detour);
                    return proxy;
                }
                return endpoint;
            }
        });
        RouteDefinition route = routeContext.getRoute();
        List<ProcessorDefinition> outputs = route.getOutputs();
        outputs.remove(this);
        return new InterceptEndpointProcessor(this.uri, detour);
    }

    public ChoiceDefinition when(Predicate predicate) {
        return this.choice().when(predicate);
    }

    public InterceptSendToEndpointDefinition skipSendToOriginalEndpoint() {
        this.setSkipSendToOriginalEndpoint(Boolean.TRUE);
        return this;
    }

    public void afterPropertiesSet() {
        if (this.getOutputs().size() == 0) {
            return;
        }
        ProcessorDefinition first = this.getOutputs().get(0);
        if (first instanceof WhenDefinition) {
            WhenDefinition when = (WhenDefinition)first;
            for (int i = 1; i < this.outputs.size(); ++i) {
                ProcessorDefinition out = (ProcessorDefinition)this.outputs.get(i);
                when.addOutput(out);
            }
            ProcessorDefinition keep = (ProcessorDefinition)this.outputs.get(0);
            this.clearOutput();
            this.outputs.add(keep);
        }
    }

    public Boolean getSkipSendToOriginalEndpoint() {
        return this.skipSendToOriginalEndpoint;
    }

    public void setSkipSendToOriginalEndpoint(Boolean skipSendToOriginalEndpoint) {
        this.skipSendToOriginalEndpoint = skipSendToOriginalEndpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

