/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.HashMap;
import java.util.Map;
import org.drools.rule.TypeDeclaration;

public class TypeMetaInfo {
    private TypeDeclaration.Kind kind;
    private TypeDeclaration.Role role;
    public static TypeMetaInfo DEFAULT_TYPE_META_INFO = new TypeMetaInfo();

    private TypeMetaInfo() {
    }

    public TypeMetaInfo(TypeDeclaration typeDeclaration) {
        this.kind = typeDeclaration.getKind();
        this.role = typeDeclaration.getRole();
    }

    public boolean isEvent() {
        return this.role == TypeDeclaration.Role.EVENT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("kind=").append(this.kind.toString().toLowerCase());
        sb.append(",");
        sb.append("role=").append(this.role.toString().toLowerCase());
        return sb.toString();
    }

    public static TypeMetaInfo fromString(String s) {
        TypeMetaInfo typeMetaInfo = new TypeMetaInfo();
        String[] split = s.split(",");
        String kind = split[0].substring("kind=".length());
        typeMetaInfo.kind = TypeDeclaration.Kind.parseKind(kind);
        String role = split[1].substring("role=".length());
        typeMetaInfo.role = TypeDeclaration.Role.parseRole(role);
        return typeMetaInfo;
    }

    public static String marshallMetaInfos(Map<String, TypeDeclaration> typeDeclarations) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, TypeDeclaration> entry : typeDeclarations.entrySet()) {
            sb.append(entry.getKey()).append("={").append(new TypeMetaInfo(entry.getValue()).toString()).append("}\n");
        }
        return sb.toString();
    }

    public static Map<String, TypeMetaInfo> unmarshallMetaInfos(String s) {
        HashMap<String, TypeMetaInfo> typeMetaInfos = new HashMap<String, TypeMetaInfo>();
        for (String line : s.split("\\n")) {
            if ((line = line.trim()).length() == 0) continue;
            int eqPos = line.indexOf(61);
            String className = line.substring(0, eqPos);
            TypeMetaInfo typeMetaInfo = TypeMetaInfo.fromString(line.substring(eqPos + 2, line.length() - 1));
            typeMetaInfos.put(className, typeMetaInfo);
        }
        return typeMetaInfos;
    }
}

