/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker;

import java.io.InputStream;
import org.drools.examples.broker.BrokerServices;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.CompanyRegistry;
import org.drools.examples.broker.model.StockTick;
import org.drools.examples.broker.ui.BrokerWindow;
import org.kie.KieBaseConfiguration;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.conf.EventProcessingOption;
import org.kie.conf.KieBaseOption;
import org.kie.conf.MBeansOption;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.SessionEntryPoint;

public class Broker
implements EventReceiver,
BrokerServices {
    private static final String[] ASSET_FILES = new String[]{"/org/drools/examples/broker/rules/broker.drl", "/org/drools/examples/broker/rules/notify.drl", "/org/drools/examples/broker/rules/position.rf", "/org/drools/examples/broker/rules/position.drl"};
    private BrokerWindow window;
    private CompanyRegistry companies;
    private StatefulKnowledgeSession session;
    private SessionEntryPoint tickStream;

    public Broker(BrokerWindow window, CompanyRegistry companies) {
        this.window = window;
        this.companies = companies;
        this.session = this.createSession();
        this.tickStream = this.session.getEntryPoint("StockTick stream");
    }

    @Override
    public void receive(Event<?> event) {
        try {
            StockTick tick = (StockTick)event.getObject();
            Company company = this.companies.getCompany(tick.getSymbol());
            this.tickStream.insert(tick);
            this.session.getAgenda().getAgendaGroup("evaluation").setFocus();
            this.session.fireAllRules();
            this.window.updateCompany(company.getSymbol());
            this.window.updateTick(tick);
        }
        catch (Exception e) {
            System.err.println("=============================================================");
            System.err.println("Unexpected exception caught: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private StatefulKnowledgeSession createSession() {
        KnowledgeBase kbase = this.loadRuleBase();
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.setGlobal("services", (Object)this);
        for (Company company : this.companies.getCompanies()) {
            session.insert((Object)company);
        }
        session.fireAllRules();
        return session;
    }

    private KnowledgeBase loadRuleBase() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            for (int i = 0; i < ASSET_FILES.length; ++i) {
                builder.add(ResourceFactory.newInputStreamResource((InputStream)Broker.class.getResourceAsStream(ASSET_FILES[i])), ResourceType.determineResourceType(ASSET_FILES[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (builder.hasErrors()) {
            System.err.println(builder.getErrors());
            System.exit(0);
        }
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KieBaseOption)MBeansOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)"Stock Broker", (KieBaseConfiguration)conf);
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        return kbase;
    }

    @Override
    public void log(String message) {
        this.window.log(message);
    }
}

