/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import org.drools.examples.conway.ConwayRuleDelegate;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.StatefulKnowledgeSession;

public class RuleFlowDelegate
implements ConwayRuleDelegate {
    private StatefulKnowledgeSession session;

    public RuleFlowDelegate() {
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"ruleflow/conway-ruleflow.drl", this.getClass()), ResourceType.DRL);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"generation.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"killAll.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"registerNeighbor.rf", this.getClass()), ResourceType.DRF);
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            this.session = kbase.newStatefulKnowledgeSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StatefulKnowledgeSession getSession() {
        return this.session;
    }

    @Override
    public void init() {
        this.session.startProcess("register neighbor");
        this.session.fireAllRules();
        this.session.getAgenda().getRuleFlowGroup("calculate").clear();
    }

    @Override
    public boolean nextGeneration() {
        this.session.startProcess("generation");
        return this.session.fireAllRules() != 0;
    }

    @Override
    public void killAll() {
        this.session.startProcess("kill all");
        this.session.fireAllRules();
    }
}

