/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.mocks;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.aries.unittest.mocks.DefaultInvocationHandler;
import org.apache.aries.unittest.mocks.DefaultMethodCallHandlers;
import org.apache.aries.unittest.mocks.DefaultReturnTypeHandlers;
import org.apache.aries.unittest.mocks.ExceptionListener;
import org.apache.aries.unittest.mocks.MethodCall;
import org.apache.aries.unittest.mocks.MethodCallHandler;
import org.apache.aries.unittest.mocks.ReturnTypeHandler;
import org.apache.aries.unittest.mocks.annotations.InjectSkeleton;
import org.apache.aries.unittest.mocks.annotations.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Skeleton
implements InvocationHandler {
    private List<MethodCall> _methodCalls;
    private DefaultInvocationHandler default_Handler;
    private Map<MethodCall, MethodCallHandler> _callHandlers;
    private Map<Class<?>, ReturnTypeHandler> _typeHandlers;
    private Map<String, Object> _mockParameters;
    private Map<Object, Map<String, Object>> _objectProperties;
    private Map<Class<?>, List<ExceptionListener>> _notificationListeners;
    private Object _template;
    private static ConcurrentMap<Object, SoftReference<Object>> _singletonMocks = new ConcurrentHashMap<Object, SoftReference<Object>>();

    private Skeleton() {
        this.reset();
    }

    public static final Object newMock(Class<?> ... interfaceClazzes) {
        return new Skeleton().createMock(interfaceClazzes);
    }

    public static final <T> T newMock(Class<T> interfaceClazz) {
        return interfaceClazz.cast(new Skeleton().createMock(interfaceClazz));
    }

    public static final <T> T newMock(final Object template, Class<T> interfaceClazz) {
        Field[] fs;
        SoftReference mock;
        Class<?> templateClass = template.getClass();
        if (templateClass.getAnnotation(Singleton.class) != null && (mock = (SoftReference)_singletonMocks.get(template)) != null) {
            Object theMock = mock.get();
            if (theMock == null) {
                _singletonMocks.remove(template);
            } else if (interfaceClazz.isInstance(theMock)) {
                return interfaceClazz.cast(theMock);
            }
        }
        Skeleton s = new Skeleton();
        s._template = template;
        for (Method m : interfaceClazz.getMethods()) {
            try {
                final Method m2 = templateClass.getMethod(m.getName(), m.getParameterTypes());
                MethodCall mc = new MethodCall(interfaceClazz, m.getName(), (Object[])m.getParameterTypes());
                s.registerMethodCallHandler(mc, new MethodCallHandler(){

                    public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
                        try {
                            m2.setAccessible(true);
                            return m2.invoke(template, methodCall.getArguments());
                        }
                        catch (InvocationTargetException ite) {
                            if (ite.getTargetException() instanceof Exception) {
                                throw (Exception)ite.getTargetException();
                            }
                            throw new Exception(ite.getTargetException());
                        }
                    }
                });
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Field f : fs = template.getClass().getFields()) {
            InjectSkeleton sk = f.getAnnotation(InjectSkeleton.class);
            if (sk == null) continue;
            f.setAccessible(true);
            try {
                f.set(template, s);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        T o = s.createMock(interfaceClazz);
        _singletonMocks.put(template, new SoftReference<Object>(o){

            @Override
            public boolean enqueue() {
                _singletonMocks.remove(template);
                System.out.println("Done cleanup");
                return super.enqueue();
            }
        });
        return interfaceClazz.cast(o);
    }

    public static final Skeleton getSkeleton(Object mock) throws IllegalArgumentException {
        InvocationHandler ih = Proxy.getInvocationHandler(mock);
        if (ih instanceof Skeleton) {
            return (Skeleton)ih;
        }
        throw new IllegalArgumentException("The supplied proxy (" + mock + ") was not an Aries dynamic mock ");
    }

    public static final boolean isSkeleton(Object mock) {
        if (Proxy.isProxyClass(mock.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(mock);
            return ih instanceof Skeleton;
        }
        return false;
    }

    @Override
    public Object invoke(Object targetObject, Method calledMethod, Object[] arguments) throws Throwable {
        Object result;
        String methodName = calledMethod.getName();
        MethodCall call = new MethodCall(targetObject, methodName, arguments);
        if (!DefaultMethodCallHandlers.isDefaultMethodCall(call)) {
            this._methodCalls.add(call);
        }
        try {
            if (this._callHandlers.containsKey(call)) {
                MethodCallHandler handler = this._callHandlers.get(call);
                result = handler.handle(call, this);
            } else if (this.isReadWriteProperty(targetObject.getClass(), calledMethod)) {
                String propertyName = methodName.substring(3);
                if (methodName.startsWith("get") || methodName.startsWith("is")) {
                    Map<String, Object> properties;
                    if (methodName.startsWith("is")) {
                        propertyName = methodName.substring(2);
                    }
                    if ((properties = this._objectProperties.get(targetObject)) == null) {
                        properties = new HashMap<String, Object>();
                        this._objectProperties.put(targetObject, properties);
                    }
                    result = properties.containsKey(propertyName) ? properties.get(propertyName) : (this._typeHandlers.containsKey(calledMethod.getReturnType()) ? this.createReturnTypeProxy(calledMethod.getReturnType()) : this.default_Handler.invoke(targetObject, calledMethod, arguments));
                } else {
                    Map<String, Object> properties = this._objectProperties.get(targetObject);
                    if (properties == null) {
                        properties = new HashMap<String, Object>();
                        this._objectProperties.put(targetObject, properties);
                    }
                    properties.put(propertyName, arguments[0]);
                    result = null;
                }
            } else {
                result = this._typeHandlers.containsKey(calledMethod.getReturnType()) ? this.createReturnTypeProxy(calledMethod.getReturnType()) : this.default_Handler.invoke(targetObject, calledMethod, arguments);
            }
        }
        catch (Throwable t) {
            Class<?> throwableType = t.getClass();
            List<ExceptionListener> listeners = this._notificationListeners.get(throwableType);
            if (listeners != null) {
                for (ExceptionListener listener : listeners) {
                    listener.exceptionNotification(t);
                }
            }
            throw t;
        }
        return result;
    }

    public void registerMethodCallHandler(MethodCall call, MethodCallHandler handler) {
        this.deRegisterMethodCallHandler(call);
        this._callHandlers.put(call, handler);
    }

    public void deRegisterMethodCallHandler(MethodCall call) {
        this._callHandlers.remove(call);
    }

    public void reset() {
        this._methodCalls = new LinkedList<MethodCall>();
        this._callHandlers = new HashMap<MethodCall, MethodCallHandler>();
        this._typeHandlers = new HashMap();
        DefaultReturnTypeHandlers.registerDefaultHandlers(this);
        DefaultMethodCallHandlers.registerDefaultHandlers(this);
        this.default_Handler = new DefaultInvocationHandler(this);
        this._mockParameters = new HashMap<String, Object>();
        this._objectProperties = new HashMap<Object, Map<String, Object>>();
        this._notificationListeners = new HashMap();
    }

    public void clearMethodCalls() {
        this._methodCalls = new LinkedList<MethodCall>();
    }

    public void setReturnValue(MethodCall call, final Object value) {
        Method[] methods;
        Class<?> clazz;
        try {
            clazz = Class.forName(call.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("This should be impossible as we have already seen this class loaded");
        }
        block2: for (Method m : methods = clazz.getMethods()) {
            Class<?>[] parms;
            Object[] args;
            if (!m.getName().equals(call.getMethodName()) || (args = call.getArguments()).length != (parms = m.getParameterTypes()).length) continue;
            for (int i = 0; i < args.length; ++i) {
                if ((!(args[i] instanceof Class) || !args[i].equals(parms[i])) && !parms[i].isInstance(args[i])) continue block2;
            }
            Class<Object> returnType = m.getReturnType();
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    returnType = Boolean.class;
                } else if (returnType == Byte.TYPE) {
                    returnType = Byte.class;
                } else if (returnType == Short.TYPE) {
                    returnType = Short.class;
                } else if (returnType == Character.TYPE) {
                    returnType = Character.class;
                } else if (returnType == Integer.TYPE) {
                    returnType = Integer.class;
                } else if (returnType == Long.TYPE) {
                    returnType = Long.class;
                } else if (returnType == Float.TYPE) {
                    returnType = Float.class;
                } else if (returnType == Double.TYPE) {
                    returnType = Double.class;
                }
            }
            if (value == null || returnType.isInstance(value)) break;
            throw new IllegalArgumentException("The object cannot be returned by the requested method: " + call);
        }
        this.registerMethodCallHandler(call, new MethodCallHandler(){

            public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
                return value;
            }
        });
    }

    public void setThrows(MethodCall call, final Exception thingToThrow) {
        this.registerMethodCallHandler(call, new MethodCallHandler(){

            public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
                thingToThrow.fillInStackTrace();
                throw thingToThrow;
            }
        });
    }

    public void setThrows(MethodCall call, final Error thingToThrow) {
        this.registerMethodCallHandler(call, new MethodCallHandler(){

            public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
                thingToThrow.fillInStackTrace();
                throw thingToThrow;
            }
        });
    }

    public void registerReturnTypeHandler(Class<?> clazz, ReturnTypeHandler handler) {
        this.deRegisterReturnTypeHandler(clazz);
        this._typeHandlers.put(clazz, handler);
    }

    public void deRegisterReturnTypeHandler(Class<?> clazz) {
        this._typeHandlers.remove(clazz);
    }

    public void registerExceptionListener(Class<?> throwableType, ExceptionListener listener) {
        List<ExceptionListener> l = this._notificationListeners.get(throwableType);
        if (l == null) {
            l = new ArrayList<ExceptionListener>();
            this._notificationListeners.put(throwableType, l);
        }
        l.add(listener);
    }

    public void setParameter(String key, Object value) {
        this._mockParameters.put(key, value);
    }

    public Object getParameter(String key) {
        return this._mockParameters.get(key);
    }

    public Object getTemplateObject() {
        return this._template;
    }

    public void setDefaultHandler(DefaultInvocationHandler defaultHandler) {
        this.default_Handler = defaultHandler;
    }

    public boolean checkCalls(List<MethodCall> calls, boolean allCalls) {
        boolean found = false;
        if (allCalls) {
            return ((Object)calls).equals(this._methodCalls);
        }
        Iterator<MethodCall> actual = this._methodCalls.iterator();
        block0: for (MethodCall expectedCall : calls) {
            found = false;
            while (actual.hasNext()) {
                MethodCall actualCall = actual.next();
                if (!actualCall.equals(expectedCall)) continue;
                found = true;
                continue block0;
            }
        }
        return found;
    }

    public boolean checkCall(MethodCall call) {
        return this._methodCalls.contains(call);
    }

    public void assertCalled(List<MethodCall> calls, boolean allCalls) throws AssertionFailedError {
        if (allCalls) {
            if (calls == null && this._methodCalls == null) {
                return;
            }
            if (calls == null) {
                throw new AssertionFailedError("expected null, but was " + this._methodCalls);
            }
            if (this._methodCalls == null) {
                throw new AssertionFailedError("expected:" + calls + " but was null");
            }
            if (((Object)calls).equals(this._methodCalls)) {
                return;
            }
            int startOfDifferences = 0;
            boolean lastItemSame = true;
            for (int i = 0; i < calls.size() && i < this._methodCalls.size() && lastItemSame; ++i) {
                lastItemSame = calls.get(i) == null && this._methodCalls.get(i) == null ? true : (calls.get(i) == null || this._methodCalls.get(i) == null ? false : calls.get(i).equals(this._methodCalls.get(i)));
                if (!lastItemSame) continue;
                ++startOfDifferences;
            }
            int endOfDifferencesInExpected = calls.size();
            int endOfDifferencesInReceived = this._methodCalls.size();
            lastItemSame = true;
            while (endOfDifferencesInExpected > startOfDifferences && endOfDifferencesInReceived > startOfDifferences && lastItemSame) {
                int ap = endOfDifferencesInExpected - 1;
                int bp = endOfDifferencesInReceived - 1;
                lastItemSame = calls.get(ap) == null && this._methodCalls.get(bp) == null ? true : (calls.get(ap) == null || this._methodCalls.get(bp) == null ? false : calls.get(ap).equals(this._methodCalls.get(bp)));
                if (!lastItemSame) continue;
                --endOfDifferencesInExpected;
                --endOfDifferencesInReceived;
            }
            String failureText = endOfDifferencesInExpected == startOfDifferences ? "Expected calls and actual calls differed because " + this._methodCalls.subList(startOfDifferences, endOfDifferencesInReceived) + " inserted after element " + startOfDifferences : (endOfDifferencesInReceived == startOfDifferences ? "Expected calls and actual calls differed  because " + calls.subList(startOfDifferences, endOfDifferencesInExpected) + " missing after element " + startOfDifferences : (endOfDifferencesInExpected == startOfDifferences + 1 && endOfDifferencesInReceived == startOfDifferences + 1 ? "Expected calls and actual calls differed  because element " + startOfDifferences + " is different (calls:" + calls.get(startOfDifferences) + " but was:" + this._methodCalls.get(startOfDifferences) + ") " : (endOfDifferencesInExpected == startOfDifferences + 1 ? "Expected calls and actual calls differed  because element " + startOfDifferences + " (" + calls.get(startOfDifferences) + ") has been replaced by " + this._methodCalls.subList(startOfDifferences, endOfDifferencesInReceived) : "Expected calls and actual calls differed  because elements between " + startOfDifferences + " and " + (endOfDifferencesInExpected - 1) + " are different (expected:" + calls.subList(startOfDifferences, endOfDifferencesInExpected) + " but was:" + this._methodCalls.subList(startOfDifferences, endOfDifferencesInReceived) + ")")));
            throw new AssertionFailedError(failureText + " expected:" + calls + " but was:" + this._methodCalls);
        }
        Iterator<MethodCall> expected = calls.iterator();
        Iterator<MethodCall> actual = this._methodCalls.iterator();
        while (expected.hasNext()) {
            boolean found = false;
            MethodCall expectedCall = expected.next();
            MethodCall actualCall = null;
            while (actual.hasNext()) {
                actualCall = actual.next();
                if (!actualCall.equals(expectedCall)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new AssertionFailedError("The method call " + expectedCall + " was expected but has not occurred (actual calls = " + this._methodCalls + ")");
        }
    }

    public void assertCalled(MethodCall call) {
        if (!this.checkCall(call)) {
            throw new AssertionFailedError("The method call " + call + " was expected but has not occurred. Actual calls: " + this.getMethodCallsAsString());
        }
    }

    public void assertCalledExactNumberOfTimes(MethodCall call, int numberOfCalls) {
        int callCount = 0;
        for (MethodCall callMade : this._methodCalls) {
            if (!callMade.equals(call)) continue;
            ++callCount;
        }
        if (numberOfCalls != callCount) {
            throw new AssertionFailedError("The method call " + call + " should have been called " + numberOfCalls + " time(s), but was called " + callCount + " time(s)");
        }
    }

    public void assertNotCalled(MethodCall call) {
        Assert.assertFalse((String)("The method call " + call + " occurred in the skeleton " + this.toString()), (boolean)this.checkCall(call));
    }

    public void assertSkeletonNotCalled() {
        Assert.assertEquals((String)("The skeleton " + this.toString() + " has had the following method invoked on it " + this.getMethodCallsAsString()), (int)0, (int)this._methodCalls.size());
    }

    public Object createMock(Class<?> ... interfaceClasses) {
        ClassLoader cl = interfaceClasses.length > 0 ? interfaceClasses[0].getClassLoader() : Thread.currentThread().getContextClassLoader();
        return Proxy.newProxyInstance(cl, interfaceClasses, (InvocationHandler)this);
    }

    public <T> T createMock(Class<T> interfaceClass) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this));
    }

    public Object invokeReturnTypeHandlers(Class<?> type) throws Exception {
        if (this._typeHandlers.containsKey(type)) {
            ReturnTypeHandler rth = this._typeHandlers.get(type);
            return rth.handle(type, this);
        }
        if (type.isInterface()) {
            return this.createMock((Class<T>)type);
        }
        return null;
    }

    @Deprecated
    private final Object createReturnTypeProxy(Class<?> type) throws Exception {
        return this.invokeReturnTypeHandlers(type);
    }

    private boolean isReadWriteProperty(Class<?> objClass, Method method) {
        boolean result;
        block17: {
            Class<?>[] parameters;
            String propertyName;
            String methodName;
            block19: {
                block18: {
                    methodName = method.getName();
                    propertyName = methodName.substring(3);
                    parameters = method.getParameterTypes();
                    result = false;
                    if (!methodName.startsWith("get") || parameters.length != 0) break block18;
                    Class<?> clazz = method.getReturnType();
                    try {
                        objClass.getMethod("set" + propertyName, clazz);
                        result = true;
                    }
                    catch (NoSuchMethodException e) {
                        if (!this.isPrimitive(clazz)) break block17;
                        clazz = this.getOtherForm(clazz);
                        try {
                            objClass.getMethod("set" + propertyName, clazz);
                            result = true;
                            break block17;
                        }
                        catch (NoSuchMethodException e1) {}
                    }
                    break block17;
                }
                if (!methodName.startsWith("is") || parameters.length != 0) break block19;
                Class<?> clazz = method.getReturnType();
                if (!clazz.equals(Boolean.class) && !clazz.equals(Boolean.TYPE)) break block17;
                propertyName = methodName.substring(2);
                try {
                    objClass.getMethod("set" + propertyName, clazz);
                    result = true;
                }
                catch (NoSuchMethodException e) {
                    if (!this.isPrimitive(clazz)) break block17;
                    clazz = this.getOtherForm(clazz);
                    try {
                        objClass.getMethod("set" + propertyName, clazz);
                        result = true;
                        break block17;
                    }
                    catch (NoSuchMethodException e1) {}
                }
                {
                    break block17;
                }
            }
            if (methodName.startsWith("set") && parameters.length == 1) {
                Class<?> clazz = parameters[0];
                try {
                    Method getter = objClass.getMethod("get" + propertyName, new Class[0]);
                    result = this.checkClasses(getter.getReturnType(), clazz);
                }
                catch (NoSuchMethodException e) {
                    if (!this.isPrimitive(clazz)) break block17;
                    clazz = this.getOtherForm(clazz);
                    try {
                        Method getter = objClass.getMethod("get" + propertyName, new Class[0]);
                        result = this.checkClasses(getter.getReturnType(), clazz);
                    }
                    catch (NoSuchMethodException e1) {
                        if (!clazz.equals(Boolean.class) && !clazz.equals(Boolean.TYPE)) break block17;
                        try {
                            Method getter = objClass.getMethod("is" + propertyName, new Class[0]);
                            result = this.checkClasses(getter.getReturnType(), clazz);
                        }
                        catch (NoSuchMethodException e2) {
                            clazz = this.getOtherForm(clazz);
                            try {
                                Method getter = objClass.getMethod("is" + propertyName, new Class[0]);
                                result = this.checkClasses(getter.getReturnType(), clazz);
                            }
                            catch (NoSuchMethodException e3) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private boolean isPrimitive(Class<?> clazz) {
        boolean result = false;
        result = clazz.isPrimitive() ? true : clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Character.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class);
        return result;
    }

    private Class<?> getOtherForm(Class<?> clazz) {
        Class result = null;
        if (clazz.equals(Boolean.TYPE)) {
            result = Boolean.class;
        } else if (clazz.equals(Byte.TYPE)) {
            result = Byte.class;
        } else if (clazz.equals(Short.TYPE)) {
            result = Short.class;
        } else if (clazz.equals(Character.TYPE)) {
            result = Character.class;
        } else if (clazz.equals(Integer.TYPE)) {
            result = Integer.class;
        } else if (clazz.equals(Long.TYPE)) {
            result = Long.class;
        } else if (clazz.equals(Float.TYPE)) {
            result = Float.class;
        } else if (clazz.equals(Double.TYPE)) {
            result = Double.class;
        } else if (clazz.equals(Boolean.class)) {
            result = Boolean.TYPE;
        } else if (clazz.equals(Byte.class)) {
            result = Byte.TYPE;
        } else if (clazz.equals(Short.class)) {
            result = Short.TYPE;
        } else if (clazz.equals(Character.class)) {
            result = Character.TYPE;
        } else if (clazz.equals(Integer.class)) {
            result = Integer.TYPE;
        } else if (clazz.equals(Long.class)) {
            result = Long.TYPE;
        } else if (clazz.equals(Float.class)) {
            result = Float.TYPE;
        } else if (clazz.equals(Double.class)) {
            result = Double.TYPE;
        }
        return result;
    }

    private boolean checkClasses(Class<?> type1, Class<?> type2) {
        boolean result = false;
        result = type1.isPrimitive() && type2.isPrimitive() || !type1.isPrimitive() && !type2.isPrimitive() ? type1.equals(type2) : type1.equals(Boolean.TYPE) && type2.equals(Boolean.class) || type1.equals(Byte.TYPE) && type2.equals(Byte.class) || type1.equals(Short.TYPE) && type2.equals(Short.class) || type1.equals(Character.TYPE) && type2.equals(Character.class) || type1.equals(Integer.TYPE) && type2.equals(Integer.class) || type1.equals(Long.TYPE) && type2.equals(Long.class) || type1.equals(Float.TYPE) && type2.equals(Float.class) || type1.equals(Double.TYPE) && type2.equals(Double.class) || type2.equals(Boolean.TYPE) && type1.equals(Boolean.class) || type2.equals(Byte.TYPE) && type1.equals(Byte.class) || type2.equals(Short.TYPE) && type1.equals(Short.class) || type2.equals(Character.TYPE) && type1.equals(Character.class) || type2.equals(Integer.TYPE) && type1.equals(Integer.class) || type2.equals(Long.TYPE) && type1.equals(Long.class) || type2.equals(Float.TYPE) && type1.equals(Float.class) || type2.equals(Double.TYPE) && type1.equals(Double.class);
        return result;
    }

    private String getMethodCallsAsString() {
        StringBuilder builder = new StringBuilder();
        for (MethodCall call : this._methodCalls) {
            builder.append(call);
            builder.append("\r\n");
        }
        return builder.toString();
    }
}

