/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.time.TimeUtils;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.process.core.validation.impl.ProcessValidationErrorImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.definition.process.NodeContainer;
import org.kie.definition.process.Process;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFlowProcessValidator
implements ProcessValidator {
    private static RuleFlowProcessValidator instance;
    private static Logger logger;
    private boolean startNodeFound;
    private boolean endNodeFound;

    private RuleFlowProcessValidator() {
    }

    public static RuleFlowProcessValidator getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidator();
        }
        return instance;
    }

    public ProcessValidationError[] validateProcess(RuleFlowProcess process) {
        ArrayList<ProcessValidationError> errors = new ArrayList<ProcessValidationError>();
        if (process.getName() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no id."));
        }
        if (process.getPackageName() == null || "".equals(process.getPackageName())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no package name."));
        }
        if (process.getStart() == null && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        this.startNodeFound = false;
        this.endNodeFound = false;
        Node[] nodes = process.getNodes();
        this.validateNodes(nodes, errors, process);
        if (!this.startNodeFound && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        if (!this.endNodeFound) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no end node."));
        }
        this.validateVariables(errors, process);
        this.checkAllNodesConnectedToStart(process, errors);
        return errors.toArray(new ProcessValidationError[errors.size()]);
    }

    private void validateNodes(Node[] nodes, List<ProcessValidationError> errors, RuleFlowProcess process) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof StartNode) {
                StartNode startNode = (StartNode)node;
                this.startNodeFound = true;
                if (startNode.getTo() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Start node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                continue;
            }
            if (node instanceof EndNode) {
                EndNode endNode = (EndNode)node;
                this.endNodeFound = true;
                if (endNode.getFrom() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "End node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                continue;
            }
            if (node instanceof RuleSetNode) {
                String ruleFlowGroup;
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) == null || "".equals(ruleFlowGroup)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no ruleflow-group."));
                }
                if (ruleSetNode.getTimers() == null) continue;
                for (Timer timer : ruleSetNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (split.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (split.getDefaultOutgoingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have more than one outgoing connection: " + split.getOutgoingConnections().size() + "."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    if (split.getConstraint(connection) != null || split.getConstraint(connection).isDefault() || split.getConstraint(connection).getConstraint() != null && split.getConstraint(connection).getConstraint().trim().length() != 0) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have a constraint for " + connection.toString() + "."));
                }
                continue;
            }
            if (node instanceof Join) {
                String n;
                Join join = (Join)node;
                if (join.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (join.getDefaultIncomingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] does not have more than one incoming connection: " + join.getIncomingConnections().size() + "."));
                }
                if (join.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (join.getType() != 4 || (n = join.getN()).startsWith("#{") && n.endsWith("}")) continue;
                try {
                    new Integer(n);
                }
                catch (NumberFormatException numberFormatException) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has illegal n value: " + n));
                }
                continue;
            }
            if (node instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)node;
                if (milestone.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (milestone.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (milestone.getConstraint() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no constraint."));
                }
                if (milestone.getTimers() == null) continue;
                for (Timer timer : milestone.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                if (stateNode.getDefaultIncomingConnections().size() != 0 || this.acceptsNoIncomingConnections(node)) continue;
                errors.add(new ProcessValidationErrorImpl(process, "State node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                continue;
            }
            if (node instanceof SubProcessNode) {
                SubProcessNode subProcess = (SubProcessNode)node;
                if (subProcess.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (subProcess.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (subProcess.getProcessId() == null && subProcess.getProcessName() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no process id."));
                }
                if (subProcess.getTimers() != null) {
                    for (Timer timer : subProcess.getTimers().keySet()) {
                        this.validateTimer(timer, node, process, errors);
                    }
                }
                if (subProcess.isIndependent() || subProcess.isWaitForCompletion()) continue;
                errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] you can only set " + "independent to 'false' only when 'Wait for completion' is set to true."));
                continue;
            }
            if (node instanceof ActionNode) {
                ActionNode actionNode = (ActionNode)node;
                if (actionNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (actionNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (actionNode.getAction() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no action."));
                    continue;
                }
                if (!(actionNode.getAction() instanceof DroolsConsequenceAction)) continue;
                DroolsConsequenceAction droolsAction = (DroolsConsequenceAction)actionNode.getAction();
                String string = droolsAction.getConsequence();
                if (string == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has empty action."));
                    continue;
                }
                if (!"mvel".equals(droolsAction.getDialect())) continue;
                try {
                    ExpressionCompiler compiler = new ExpressionCompiler(string);
                    compiler.setVerifying(true);
                    ParserContext parserContext = new ParserContext();
                    compiler.compile(parserContext);
                    List mvelErrors = parserContext.getErrorList();
                    if (mvelErrors == null) continue;
                    for (ErrorDetail error : mvelErrors) {
                        errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + error.getMessage() + "."));
                    }
                    continue;
                }
                catch (Throwable t) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + t.getMessage() + "."));
                    continue;
                }
            }
            if (node instanceof WorkItemNode) {
                WorkItemNode workItemNode = (WorkItemNode)node;
                if (workItemNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (workItemNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (workItemNode.getWork() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work specified."));
                } else {
                    Work work = workItemNode.getWork();
                    if (work.getName() == null) {
                        errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work name."));
                    }
                }
                if (workItemNode.getTimers() == null) continue;
                for (Timer timer : workItemNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof ForEachNode) {
                String string;
                ForEachNode forEachNode = (ForEachNode)node;
                String variableName = forEachNode.getVariableName();
                if (variableName == null || "".equals(variableName)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no variable name"));
                }
                if ((string = forEachNode.getCollectionExpression()) == null || "".equals(string)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no collection expression"));
                }
                if (forEachNode.getDefaultIncomingConnections().size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                }
                if (forEachNode.getDefaultOutgoingConnections().size() == 0 && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                }
                this.validateNodes(forEachNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof DynamicNode) {
                DynamicNode dynamicNode = (DynamicNode)node;
                if (dynamicNode.getDefaultIncomingConnections().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Dynamic node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                }
                if (dynamicNode.getDefaultOutgoingConnections().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Dynamic node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                }
                this.validateNodes(dynamicNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof CompositeNode) {
                CompositeNode compositeNode = (CompositeNode)node;
                for (Map.Entry entry : compositeNode.getLinkedIncomingNodes().entrySet()) {
                    if (compositeNode.getIncomingConnections((String)entry.getKey()).size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection for type " + (String)entry.getKey()));
                    }
                    if (((CompositeNode.NodeAndType)entry.getValue()).getNode() != null || this.acceptsNoOutgoingConnections(node)) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked incoming node for type " + (String)entry.getKey()));
                }
                for (Map.Entry entry : compositeNode.getLinkedOutgoingNodes().entrySet()) {
                    if (compositeNode.getOutgoingConnections((String)entry.getKey()).size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection for type " + (String)entry.getKey()));
                    }
                    if (((CompositeNode.NodeAndType)entry.getValue()).getNode() != null) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked outgoing node for type " + (String)entry.getKey()));
                }
                this.validateNodes(compositeNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof EventNode) {
                EventNode eventNode = (EventNode)node;
                if (eventNode.getEventFilters().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] should specify an event type"));
                }
                if (eventNode.getDefaultOutgoingConnections().size() != 0) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                continue;
            }
            if (node instanceof FaultNode) {
                this.endNodeFound = true;
                FaultNode faultNode = (FaultNode)node;
                if (faultNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (faultNode.getFaultName() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no fault name."));
                continue;
            }
            if (node instanceof TimerNode) {
                TimerNode timerNode = (TimerNode)node;
                if (timerNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (timerNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (timerNode.getTimer() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no timer specified."));
                    continue;
                }
                this.validateTimer(timerNode.getTimer(), node, process, errors);
                continue;
            }
            if (node instanceof CatchLinkNode || node instanceof ThrowLinkNode) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Unknown node type '" + node.getClass().getName() + "'"));
        }
    }

    private void checkAllNodesConnectedToStart(RuleFlowProcess process, List<ProcessValidationError> errors) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = process.getNodes();
        ArrayList<Node> eventNodes = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
            if (!(node instanceof EventNode)) continue;
            eventNodes.add(node);
        }
        if (process.isDynamic()) {
            for (Node node : process.getNodes()) {
                if (!node.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) continue;
                this.processNode(node, processNodes);
            }
        } else {
            StartNode start = process.getStart();
            if (start != null) {
                this.processNode(start, processNodes);
            }
        }
        for (Node eventNode : eventNodes) {
            this.processNode(eventNode, processNodes);
        }
        for (Node node : processNodes.keySet()) {
            if (!Boolean.FALSE.equals(processNodes.get(node)) || node instanceof StartNode || node instanceof EventSubProcessNode) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] has no connection to the start node."));
        }
    }

    private void processNode(Node node, Map<Node, Boolean> nodes) {
        if (!nodes.containsKey(node)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process: " + node.getName());
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE) {
            for (List list : node.getOutgoingConnections().values()) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    this.processNode(((Connection)it2.next()).getTo(), nodes);
                }
            }
        }
    }

    private boolean acceptsNoIncomingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private boolean acceptsNoOutgoingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private void validateTimer(Timer timer, Node node, RuleFlowProcess process, List<ProcessValidationError> errors) {
        if (timer.getDelay() == null && timer.getDate() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] has timer with no delay or date specified."));
        } else if (timer.getDelay() != null && !timer.getDelay().contains("#{")) {
            try {
                switch (timer.getTimeType()) {
                    case 2: {
                        if (timer.getPeriod() != null) {
                            TimeUtils.parseTimeString((String)timer.getDelay());
                            break;
                        }
                        DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                        break;
                    }
                    case 1: {
                        DateTimeUtils.parseDuration(timer.getDelay());
                        break;
                    }
                    case 3: {
                        DateTimeUtils.parseDateAsDuration(timer.getDate());
                        break;
                    }
                }
            }
            catch (RuntimeDroolsException e) {
                errors.add(new ProcessValidationErrorImpl(process, "Could not parse delay '" + timer.getDelay() + "' of node '" + node.getName() + "': " + e.getMessage()));
            }
        }
        if (timer.getPeriod() != null && !timer.getPeriod().contains("#{")) {
            try {
                TimeUtils.parseTimeString((String)timer.getPeriod());
            }
            catch (RuntimeDroolsException e) {
                errors.add(new ProcessValidationErrorImpl(process, "Could not parse period '" + timer.getPeriod() + "' of node '" + node.getName() + "': " + e.getMessage()));
            }
        }
    }

    @Override
    public ProcessValidationError[] validateProcess(Process process) {
        if (!(process instanceof RuleFlowProcess)) {
            throw new IllegalArgumentException("This validator can only validate ruleflow processes!");
        }
        return this.validateProcess((RuleFlowProcess)process);
    }

    private void validateVariables(List<ProcessValidationError> errors, RuleFlowProcess process) {
        List<Variable> variables = process.getVariableScope().getVariables();
        if (variables != null) {
            for (Variable var : variables) {
                DataType varDataType = var.getType();
                if (varDataType == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Variable '" + var.getName() + "' has no type."));
                }
                String stringType = varDataType.getStringType();
                if (!(varDataType instanceof ObjectDataType)) continue;
                if ("java.lang.Object".equals(stringType) || "Object".equals(stringType)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Process variable " + var.getName() + " must have a defined concrete type, currently '" + stringType + "' and data type '" + varDataType.getClass().getName()));
                    continue;
                }
                if (!stringType.startsWith("java.lang")) continue;
                logger.warn("Process variable " + var.getName() + " uses ObjectDataType for default type (java.lang) " + "which could cause problems with setting variables, use dedicated type instead");
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(RuleFlowProcessValidator.class);
    }
}

