/*
 * Decompiled with CFR 0.152.
 */
package org.drools.fluent.batch.imp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.command.IdentifiableResult;
import org.drools.command.impl.GenericCommand;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.SetGlobalCommand;
import org.drools.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.process.StartProcessInstanceCommand;
import org.drools.command.runtime.rule.DeleteCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.fluent.batch.FluentBatchExecution;
import org.drools.fluent.test.impl.MapVariableContext;
import org.kie.command.BatchExecutionCommand;
import org.kie.fluent.VariableContext;
import org.kie.runtime.rule.FactHandle;

public class FluentBatchExecutionImpl
implements FluentBatchExecution {
    private List<GenericCommand<?>> cmds = new ArrayList();
    private VariableContext vars = new MapVariableContext();
    private GenericCommand<?> lastAddedCommand;

    public void addCommand(GenericCommand<?> cmd) {
        this.cmds.add(cmd);
    }

    public <P> VariableContext<P> getVariableContext() {
        return this.vars;
    }

    @Override
    public BatchExecutionCommand getBatchExecution() {
        return new BatchExecutionCommandImpl(this.cmds);
    }

    @Override
    public FluentBatchExecution newBatchExecution() {
        return this;
    }

    @Override
    public FluentBatchExecution insert(Object object) {
        this.lastAddedCommand = new InsertObjectCommand(object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    @Override
    public FluentBatchExecution update(FactHandle handle, Object object) {
        this.lastAddedCommand = new InsertObjectCommand(object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    @Override
    public FluentBatchExecution delete(FactHandle handle) {
        this.lastAddedCommand = new DeleteCommand(handle);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    @Override
    public FluentBatchExecution fireAllRules() {
        this.addCommand((GenericCommand<?>)new FireAllRulesCommand());
        return this;
    }

    @Override
    public FluentBatchExecution assertRuleFired(String ruleName) {
        throw new UnsupportedOperationException("FluentBatchExecutionImpl duplicates DefaultStatefulKnowledgeSessionSimFluent");
    }

    @Override
    public FluentBatchExecution assertRuleFired(String ruleName, int fireCount) {
        throw new UnsupportedOperationException("FluentBatchExecutionImpl duplicates DefaultStatefulKnowledgeSessionSimFluent");
    }

    @Override
    public FluentBatchExecution setGlobal(String identifier, Object object) {
        this.lastAddedCommand = new SetGlobalCommand(identifier, object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    @Override
    public FluentBatchExecution set(String name) {
        if (this.lastAddedCommand instanceof IdentifiableResult) {
            ((IdentifiableResult)this.lastAddedCommand).setOutIdentifier(name);
        } else {
            Logger.getLogger(FluentBatchExecutionImpl.class.getName()).log(Level.WARNING, "The lastAddedCommand class (" + this.lastAddedCommand.getClass() + ") is not an instanceof IdentifiableResult.\n " + "As result, the variable '" + name + "' will not be set.");
        }
        return this;
    }

    public FluentBatchExecution startProcess(String identifier, Map<String, Object> params) {
        this.lastAddedCommand = new StartProcessCommand(identifier, params);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution startProcess(String identifier) {
        this.lastAddedCommand = new StartProcessCommand(identifier);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution createProcessInstance(String identifier, Map<String, Object> params) {
        this.lastAddedCommand = new CreateProcessInstanceCommand(identifier, params);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution startProcessInstance(long processId) {
        this.lastAddedCommand = new StartProcessInstanceCommand(Long.valueOf(processId));
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution signalEvent(String id, Object event, long processId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FluentBatchExecution signalEvent(String id, Object event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

