/*
 * Decompiled with CFR 0.152.
 */
package org.drools.fluent.simulation.impl;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.command.GetVariableCommand;
import org.drools.command.NewKieSessionCommand;
import org.drools.command.SetVariableCommandFromLastReturn;
import org.drools.fluent.session.StatefulKnowledgeSessionSimFluent;
import org.drools.fluent.session.impl.DefaultStatefulKnowledgeSessionSimFluent;
import org.drools.fluent.simulation.SimulationFluent;
import org.drools.fluent.test.impl.AbstractTestableFluent;
import org.drools.fluent.test.impl.MapVariableContext;
import org.drools.simulation.impl.SimulationImpl;
import org.drools.simulation.impl.SimulationPathImpl;
import org.drools.simulation.impl.SimulationStepImpl;
import org.drools.simulation.impl.Simulator;
import org.kie.builder.ReleaseId;
import org.kie.command.Command;
import org.kie.fluent.VariableContext;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.simulation.Simulation;
import org.kie.simulation.SimulationPath;
import org.kie.simulation.SimulationStep;

public class DefaultSimulationFluent
extends AbstractTestableFluent<SimulationFluent>
implements SimulationFluent {
    private Simulation simulation = new SimulationImpl();
    private VariableContext variableContext = new MapVariableContext();
    private SimulationPath activePath = null;
    private int pathCounter = 0;
    private SimulationStep activeStep = null;
    private String activeKieSessionId = null;
    private static final String DEFAULT_ID = "__DEFAULT__";

    public <P> VariableContext<P> getVariableContext() {
        return this.variableContext;
    }

    public SimulationFluent newPath() {
        String pathId = "path" + this.pathCounter;
        ++this.pathCounter;
        this.activeKieSessionId = null;
        return this.newPath(pathId);
    }

    @Override
    public SimulationFluent newPath(String id) {
        this.activePath = new SimulationPathImpl(this.simulation, id);
        this.simulation.getPaths().put(id, this.activePath);
        this.activeStep = null;
        return this;
    }

    @Override
    public SimulationFluent getPath(String id) {
        this.activePath = (SimulationPath)this.simulation.getPaths().get(id);
        if (this.activePath == null) {
            throw new IllegalArgumentException("There is no path with path id (" + id + ") created yet." + " Call newPath(id) first.");
        }
        List steps = this.activePath.getSteps();
        this.activeStep = (SimulationStep)steps.get(steps.size() - 1);
        return this;
    }

    private void assureActivePath() {
        if (this.activePath == null) {
            this.newPath();
        }
    }

    public SimulationPath getActivePath() {
        return this.activePath;
    }

    @Override
    public SimulationFluent newStep(long distanceMillis) {
        this.assureActivePath();
        this.activeStep = new SimulationStepImpl(this.activePath, distanceMillis);
        this.activePath.getSteps().add(this.activeStep);
        return this;
    }

    @Override
    public SimulationFluent newStep(long distanceMillis, TimeUnit timeUnit) {
        return this.newStep(timeUnit.toMillis(distanceMillis));
    }

    @Override
    public SimulationFluent newRelativeStep(long relativeDistanceMillis) {
        if (this.activeStep == null) {
            return this.newStep(relativeDistanceMillis);
        }
        return this.newStep(this.activeStep.getDistanceMillis() + relativeDistanceMillis);
    }

    @Override
    public SimulationFluent newRelativeStep(long relativeDistance, TimeUnit timeUnit) {
        return this.newRelativeStep(timeUnit.toMillis(relativeDistance));
    }

    private void assureActiveStep() {
        if (this.activeStep == null) {
            this.newStep(0L);
        }
    }

    public SimulationStep getActiveStep() {
        return this.activeStep;
    }

    public SimulationFluent addCommand(Command command) {
        this.activeStep.getCommands().add(command);
        return this;
    }

    @Override
    public String getActiveKieSessionId() {
        return this.activeKieSessionId;
    }

    public StatefulKnowledgeSessionSimFluent newKieSession() {
        return this.newKieSession(null, null);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newKieSession(ReleaseId releaseId, String id) {
        this.assureActiveStep();
        this.activeKieSessionId = id == null ? DEFAULT_ID : id;
        this.addCommand((Command)new NewKieSessionCommand(releaseId, id));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(StatefulKnowledgeSession.class.getName()));
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent getKieSession() {
        if (this.activeKieSessionId == null) {
            throw new IllegalStateException("There is no activeKnowledgeSession. Call newStatefulKnowledgeSession() instead.");
        }
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent getKieSession(String id) {
        this.activeKieSessionId = id;
        this.addCommand((Command)new GetVariableCommand(id));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(StatefulKnowledgeSession.class.getName()));
        return new DefaultStatefulKnowledgeSessionSimFluent(this);
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public void runSimulation() {
        this.runSimulation(new Date().getTime());
    }

    @Override
    public void runSimulation(long startTimeMillis) {
        Simulator simulator = new Simulator(this.simulation, startTimeMillis);
        simulator.run();
    }
}

