/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.command.GetDefaultValue;
import org.drools.command.NewKieSessionCommand;
import org.drools.command.ResolvingKnowledgeCommandContext;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.simulation.impl.SimulationImpl;
import org.drools.simulation.impl.SimulationPathImpl;
import org.drools.simulation.impl.SimulationStepImpl;
import org.drools.time.SessionPseudoClock;
import org.kie.command.Command;
import org.kie.command.Context;
import org.kie.command.World;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.simulation.Simulation;
import org.kie.simulation.SimulationPath;
import org.kie.simulation.SimulationStep;

public class Simulator
implements World,
GetDefaultValue {
    private PriorityQueue<SimulationStep> queue;
    private SimulationImpl simulation;
    private long startTime;
    private Context root;
    private Map<String, Context> contexts;
    private static String ROOT = "ROOT";
    private Set<StatefulKnowledgeSession> ksessions;
    private CommandExecutionHandler executionHandler = new DefaultCommandExecutionHandler();
    private Object lastReturnValue;

    public Simulator(Simulation simulation, long startTime) {
        this.ksessions = new HashSet<StatefulKnowledgeSession>();
        this.startTime = startTime;
        this.simulation = (SimulationImpl)simulation;
        this.root = new ContextImpl(ROOT, (World)this);
        this.root.set("simulator", (Object)this);
        this.contexts = new HashMap<String, Context>();
        this.contexts.put(ROOT, this.root);
        Map<String, SimulationPath> paths = this.simulation.getPaths();
        int capacity = 0;
        for (SimulationPath path : paths.values()) {
            this.contexts.put(path.getName(), (Context)new ContextImpl(path.getName(), (World)this, this.root));
            capacity += path.getSteps().size();
        }
        if (capacity == 0) {
            return;
        }
        this.queue = new PriorityQueue<SimulationStep>(capacity, new Comparator<SimulationStep>(){

            @Override
            public int compare(SimulationStep s1, SimulationStep s2) {
                return (int)(s1.getDistanceMillis() - s2.getDistanceMillis());
            }
        });
        for (SimulationPath path : paths.values()) {
            for (SimulationStep step : path.getSteps()) {
                this.queue.add(step);
            }
        }
    }

    public void run() {
        SimulationStep step;
        while ((step = this.executeNextStep()) != null) {
        }
    }

    public SimulationStep executeNextStep() {
        if (this.queue.isEmpty()) {
            return null;
        }
        SimulationStepImpl step = (SimulationStepImpl)this.queue.remove();
        SimulationPathImpl path = (SimulationPathImpl)step.getPath();
        ResolvingKnowledgeCommandContext pathContext = new ResolvingKnowledgeCommandContext(this.contexts.get(path.getName()));
        for (StatefulKnowledgeSession ksession : this.ksessions) {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            long newTime = this.startTime + step.getDistanceMillis();
            long currentTime = clock.getCurrentTime();
            clock.advanceTime(newTime - currentTime, TimeUnit.MILLISECONDS);
        }
        for (Command cmd : step.getCommands()) {
            if (cmd instanceof NewKieSessionCommand) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.executionHandler.execute((GenericCommand)cmd, (Context)pathContext);
                if (ksession == null) continue;
                SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
                long newTime = this.startTime + step.getDistanceMillis();
                long currentTime = clock.getCurrentTime();
                clock.advanceTime(newTime - currentTime, TimeUnit.MILLISECONDS);
                this.ksessions.add(ksession);
                this.lastReturnValue = ksession;
                continue;
            }
            if (!(cmd instanceof GenericCommand)) continue;
            this.lastReturnValue = this.executionHandler.execute((GenericCommand)cmd, (Context)pathContext);
        }
        return step;
    }

    public void setCommandExecutionHandler(CommandExecutionHandler executionHandler) {
        this.executionHandler = executionHandler;
    }

    public Context getContext(String identifier) {
        return this.contexts.get(identifier);
    }

    public Context getRootContext() {
        return this.root;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public Object getLastReturnValue() {
        return this.lastReturnValue;
    }

    public Object getObject() {
        return this.lastReturnValue;
    }

    public World getContextManager() {
        return this;
    }

    public String getName() {
        return this.root.getName();
    }

    public Object get(String identifier) {
        return this.root.get(identifier);
    }

    public void set(String identifier, Object value) {
        this.root.set(identifier, value);
    }

    public void remove(String identifier) {
        this.root.remove(identifier);
    }

    public static class DefaultCommandExecutionHandler
    implements CommandExecutionHandler {
        @Override
        public Object execute(GenericCommand command, Context context) {
            return command.execute(context);
        }
    }

    public static interface CommandExecutionHandler {
        public Object execute(GenericCommand var1, Context var2);
    }
}

