/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.core.util.StringUtils;
import org.drools.kproject.ReleaseIdImpl;
import org.drools.kproject.models.KieModuleModelImpl;
import org.drools.kproject.xml.MinimalPomParser;
import org.drools.kproject.xml.PomModel;
import org.kie.KieServices;
import org.kie.builder.KieModule;
import org.kie.builder.KieRepository;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.AbstractKieProject;
import org.kie.builder.impl.FileKieModule;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieBuilderImpl;
import org.kie.builder.impl.ZipKieModule;
import org.kie.builder.model.KieModuleModel;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(ClasspathKieProject.class);
    private Map<ReleaseId, InternalKieModule> kieModules = new HashMap<ReleaseId, InternalKieModule>();
    private Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private KieRepository kr;
    private CompositeClassLoader cl;

    public ClasspathKieProject() {
        this(KieServices.Factory.get().getRepository());
    }

    public ClasspathKieProject(KieRepository kr) {
        this.kr = kr;
    }

    @Override
    public void init() {
        this.cl = ClassLoaderUtil.getClassLoader(null, null, (boolean)true);
        this.discoverKieModules();
        this.indexParts(this.kieModules, this.kJarFromKBaseName);
    }

    @Override
    public ReleaseId getGAV() {
        return null;
    }

    public void discoverKieModules() {
        Enumeration e;
        try {
            e = this.cl.getResources(KieModuleModelImpl.KMODULE_JAR_PATH);
        }
        catch (IOException exc) {
            log.error("Unable to find and build index of kmodule.xml \n" + exc.getMessage());
            return;
        }
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            System.out.println("kmodules: " + url);
            try {
                String fixedURL = ClasspathKieProject.fixURLFromKProjectPath(url);
                InternalKieModule kModule = ClasspathKieProject.fetchKModule(url, fixedURL);
                ReleaseId releaseId = kModule.getReleaseId();
                this.kieModules.put(releaseId, kModule);
                log.debug("Discovered classpath module " + releaseId.toExternalForm());
                this.kr.addKieModule((KieModule)kModule);
            }
            catch (Exception exc) {
                log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n" + exc.getMessage());
            }
        }
    }

    public static InternalKieModule fetchKModule(URL url) {
        return ClasspathKieProject.fetchKModule(url, ClasspathKieProject.fixURLFromKProjectPath(url));
    }

    public static InternalKieModule fetchKModule(URL url, String fixedURL) {
        AbstractKieModule kJar;
        KieModuleModel kieProject = KieModuleModelImpl.fromXML(url);
        KieBuilderImpl.setDefaultsforEmptyKieModule(kieProject);
        String pomProperties = ClasspathKieProject.getPomProperties(fixedURL);
        ReleaseId releaseId = ReleaseIdImpl.fromPropertiesString(pomProperties);
        String rootPath = fixedURL;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = fixedURL.substring(rootPath.lastIndexOf(58) + 1);
        }
        File file = new File(rootPath);
        if (fixedURL.endsWith(".jar")) {
            kJar = new ZipKieModule(releaseId, kieProject, file);
        } else if (file.isDirectory()) {
            kJar = new FileKieModule(releaseId, kieProject, file);
        } else {
            log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n");
            kJar = null;
        }
        return kJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPomProperties(String urlPathToAdd) {
        String rootPath = urlPathToAdd;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = urlPathToAdd.substring(rootPath.lastIndexOf(58) + 1);
        }
        if (urlPathToAdd.endsWith(".jar")) {
            File actualZipFile = new File(rootPath);
            if (!actualZipFile.exists()) {
                log.error("Unable to load pom.properties from" + urlPathToAdd + " as jarPath cannot be found\n" + rootPath);
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(actualZipFile);
                String file = KieBuilderImpl.findPomProperties(zipFile);
                if (file == null) {
                    throw new IOException();
                }
                ZipEntry zipEntry = zipFile.getEntry(file);
                String pomProps = StringUtils.readFileAsString((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry)));
                log.debug("Found and used pom.properties " + file);
                String string = pomProps;
                return string;
            }
            catch (Exception e) {
                log.error("Unable to load pom.properties from" + urlPathToAdd + "\n" + e.getMessage());
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error("Error when closing InputStream to " + urlPathToAdd + "\n" + e.getMessage());
                }
            }
        }
        InputStreamReader reader = null;
        try {
            File file = KieBuilderImpl.findPomProperties(new File(rootPath));
            if (file == null) {
                throw new IOException();
            }
            reader = new FileReader(file);
            log.debug("Found and used pom.properties " + file);
            String e = StringUtils.toString((Reader)reader);
            return e;
        }
        catch (Exception e) {
            log.warn("Unable to load pom.properties tried recursing down from" + urlPathToAdd + "\n" + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error when closing InputStream to " + urlPathToAdd + "\n" + e.getMessage());
                }
            }
        }
        File file = null;
        File folder = new File(rootPath);
        while (folder != null && !(file = new File(folder, "pom.xml")).exists()) {
            file = null;
            folder = new File(folder.getParent());
        }
        if (file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                PomModel pomModel = MinimalPomParser.parse(rootPath + "/pom.xml", fis);
                KieBuilderImpl.validatePomModel(pomModel);
                ReleaseIdImpl gav = (ReleaseIdImpl)pomModel.getReleaseId();
                String str = KieBuilderImpl.generatePomProperties(gav);
                log.info("Recursed up folders,  found and used pom.xml " + file);
                String string = str;
                return string;
            }
            catch (Exception e) {
                log.error("As folder project tried to fall back to pom.xml " + file + "\nbut failed with exception:\n" + e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error("Error when closing InputStream to " + file + "\n" + e.getMessage());
                    }
                }
            }
        }
        log.error("As folder project tried to fall back to pom.xml, but could not find one for " + file);
        log.error("Unable to load pom.properties from" + urlPathToAdd);
        return null;
    }

    public static String fixURLFromKProjectPath(URL url) {
        String urlPath = url.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        urlPath = url.getPath();
        if ("jar".equals(urlType)) {
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
        } else {
            urlPath = urlPath.substring(0, urlPath.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH).length());
        }
        if ((colonIndex = urlPath.lastIndexOf(":")) >= 0) {
            urlPath = urlPath.substring(colonIndex + 1);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error decoding URL (" + url + ") using UTF-8", e);
        }
        log.debug("KieModule URL type=" + urlType + " url=" + urlPath);
        return urlPath;
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    @Override
    public CompositeClassLoader getClassLoader() {
        return this.cl;
    }
}

