/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MainRunner
implements InitializingBean,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MainRunner.class);
    private Class<?> main;
    private String[] args = new String[0];
    private boolean asyncRun = true;
    private long delay;

    public String toString() {
        return "MainRunner(" + ObjectHelper.name(this.main) + " " + Arrays.asList(this.getArgs()) + ")";
    }

    @Override
    public void run() {
        try {
            this.runMethodWithoutCatchingExceptions();
        }
        catch (NoSuchMethodException e) {
            LOG.error("Class: " + ObjectHelper.name(this.main) + " does not have a main method: " + e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to run: " + this + ". Reason: " + e, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            LOG.error("Failed to run: " + this + ". Reason: " + throwable, throwable);
        }
    }

    public void runMethodWithoutCatchingExceptions() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!Modifier.isStatic((method = this.main.getMethod("main", String[].class)).getModifiers())) {
            throw new IllegalArgumentException("The main method is not static!: " + method);
        }
        Object[] arguments = new Object[]{this.getArgs()};
        method.invoke(null, arguments);
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public boolean isAsyncRun() {
        return this.asyncRun;
    }

    public void setAsyncRun(boolean asyncRun) {
        this.asyncRun = asyncRun;
    }

    public Class getMain() {
        return this.main;
    }

    public void setMain(Class main) {
        this.main = main;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.main == null) {
            throw new IllegalArgumentException("You must specify a main class!");
        }
        if (this.isAsyncRun()) {
            Thread thread = new Thread((Runnable)this, "Thread for: " + this);
            thread.start();
        } else {
            this.runMethodWithoutCatchingExceptions();
        }
    }
}

