/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xpath;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.drools.process.instance.WorkItem;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.workflow.core.node.Assignment;
import org.kie.runtime.process.ProcessContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPATHAssignmentAction
implements AssignmentAction {
    private String sourceExpr;
    private String targetExpr;
    private Assignment assignment;
    private boolean isInput;

    public XPATHAssignmentAction(Assignment assignment, String sourceExpr, String targetExpr, boolean isInput) {
        this.assignment = assignment;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.isInput = isInput;
    }

    public void execute(WorkItem workItem, ProcessContext context) throws Exception {
        String from = this.assignment.getFrom();
        String to = this.assignment.getTo();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathFrom = factory.newXPath();
        XPathExpression exprFrom = xpathFrom.compile(from);
        XPath xpathTo = factory.newXPath();
        XPathExpression exprTo = xpathTo.compile(to);
        Object target = null;
        Object source = null;
        if (this.isInput) {
            source = context.getVariable(this.sourceExpr);
            target = workItem.getParameter(this.targetExpr);
        } else {
            target = context.getVariable(this.targetExpr);
            source = workItem.getResult(this.sourceExpr);
        }
        Object targetElem = null;
        if (target != null) {
            Node parent = null;
            parent = ((Node)target).getParentNode();
            targetElem = exprTo.evaluate(parent, XPathConstants.NODE);
            if (targetElem == null) {
                throw new RuntimeException("Nothing was selected by the to expression " + to + " on " + this.targetExpr);
            }
        }
        NodeList nl = null;
        if (source instanceof Node) {
            nl = (NodeList)exprFrom.evaluate(source, XPathConstants.NODESET);
        } else if (source instanceof String) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element temp = doc.createElementNS(null, "temp");
            temp.appendChild(doc.createTextNode((String)source));
            nl = temp.getChildNodes();
        } else if (source == null) {
            throw new RuntimeException("Source value was null for source " + this.sourceExpr);
        }
        if (nl.getLength() == 0) {
            throw new RuntimeException("Nothing was selected by the from expression " + from + " on " + this.sourceExpr);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(targetElem instanceof Node)) {
                if (nl.item(i) instanceof Attr) {
                    targetElem = ((Attr)nl.item(i)).getValue();
                } else if (nl.item(i) instanceof Text) {
                    targetElem = ((Text)nl.item(i)).getWholeText();
                } else {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.newDocument();
                    targetElem = doc.importNode(nl.item(i), true);
                }
                target = targetElem;
                continue;
            }
            Node n = ((Node)targetElem).getOwnerDocument().importNode(nl.item(i), true);
            if (n instanceof Attr) {
                ((Element)targetElem).setAttributeNode((Attr)n);
                continue;
            }
            ((Node)targetElem).appendChild(n);
        }
        if (this.isInput) {
            workItem.setParameter(this.targetExpr, target);
        } else {
            context.setVariable(this.targetExpr, target);
        }
    }
}

