/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime;

import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;

public class RemoveEventListenerCommand
implements GenericCommand<Object> {
    private WorkingMemoryEventListener workingMemoryEventListener = null;
    private AgendaEventListener agendaEventListener = null;
    private ProcessEventListener processEventListener = null;

    public RemoveEventListenerCommand(WorkingMemoryEventListener listener) {
        this.workingMemoryEventListener = listener;
    }

    public RemoveEventListenerCommand(AgendaEventListener listener) {
        this.agendaEventListener = listener;
    }

    public RemoveEventListenerCommand(ProcessEventListener listener) {
        this.processEventListener = listener;
    }

    @Override
    public Object execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.workingMemoryEventListener != null) {
            ksession.removeEventListener(this.workingMemoryEventListener);
        } else if (this.agendaEventListener != null) {
            ksession.removeEventListener(this.agendaEventListener);
        } else {
            ksession.removeEventListener(this.processEventListener);
        }
        return null;
    }

    public String toString() {
        if (this.workingMemoryEventListener != null) {
            return "session.removeEventListener( " + this.workingMemoryEventListener + " );";
        }
        if (this.agendaEventListener != null) {
            return "session.removeEventListener( " + this.agendaEventListener + " );";
        }
        return "session.removeEventListener( " + this.processEventListener + " );";
    }
}

