/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.fluent.session.impl;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.drools.core.command.GetVariableCommand;
import org.drools.core.command.SetVariableCommandFromLastReturn;
import org.drools.core.command.runtime.AddEventListenerCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.simulation.fluent.session.StatefulKnowledgeSessionSimFluent;
import org.drools.simulation.fluent.simulation.SimulationFluent;
import org.drools.simulation.fluent.simulation.impl.DefaultSimulationFluent;
import org.drools.simulation.fluent.test.impl.AbstractTestableFluent;
import org.drools.simulation.impl.command.AssertRulesFiredCommand;
import org.drools.simulation.impl.command.FiredRuleCounter;
import org.kie.api.command.Command;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.simulation.SimulationStep;

public class DefaultStatefulKnowledgeSessionSimFluent
extends AbstractTestableFluent<StatefulKnowledgeSessionSimFluent>
implements StatefulKnowledgeSessionSimFluent {
    private SimulationFluent simulationFluent;

    public DefaultStatefulKnowledgeSessionSimFluent(SimulationFluent simulationFluent) {
        this.simulationFluent = simulationFluent;
    }

    protected StatefulKnowledgeSessionSimFluent addCommand(Command command) {
        this.simulationFluent.addCommand(command);
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent setGlobal(String identifier, Object object) {
        this.addCommand((Command)new SetGlobalCommand(identifier, object));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent insert(Object object) {
        this.addCommand((Command)new InsertObjectCommand(object));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent update(FactHandle handle, Object object) {
        this.addCommand((Command)new UpdateCommand(handle, object));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent delete(FactHandle handle) {
        this.addCommand((Command)new DeleteCommand(handle));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent fireAllRules() {
        this.addCommand((Command)new FireAllRulesCommand());
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent assertRuleFired(String ruleName) {
        return this.assertRuleFired(ruleName, 1);
    }

    @Override
    public StatefulKnowledgeSessionSimFluent assertRuleFired(String ruleName, int fireCount) {
        SimulationStep activeStep = ((DefaultSimulationFluent)this.simulationFluent).getActiveStep();
        FiredRuleCounter firedRuleCounter = new FiredRuleCounter();
        firedRuleCounter.setInclusiveRuleNameList(Collections.singletonList(ruleName));
        this.insertFireRuleCounter(activeStep, firedRuleCounter);
        AssertRulesFiredCommand assertRulesFiredCommand = new AssertRulesFiredCommand(firedRuleCounter);
        assertRulesFiredCommand.addAssertRuleFired(ruleName, fireCount);
        this.addCommand((Command)assertRulesFiredCommand);
        return this;
    }

    private void insertFireRuleCounter(SimulationStep activeStep, FiredRuleCounter firedRuleCounter) {
        int lastFireAllRulesIndex = -1;
        List commands = activeStep.getCommands();
        ListIterator it = commands.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            Command command = (Command)it.next();
            if (!(command instanceof FireAllRulesCommand)) continue;
            lastFireAllRulesIndex = i;
        }
        if (lastFireAllRulesIndex < 0) {
            throw new IllegalArgumentException("Cannot assertRuleFired, because in this step, fireAllRules() hasn't been called yet.");
        }
        commands.add(lastFireAllRulesIndex, new AddEventListenerCommand((AgendaEventListener)firedRuleCounter));
    }

    public String getActiveKnowledgeSessionId() {
        return this.simulationFluent.getActiveKieSessionId();
    }

    @Override
    public SimulationFluent end(String context, String name) {
        this.addCommand((Command)new GetVariableCommand(StatefulKnowledgeSession.class.getName()));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(context, name));
        return this.simulationFluent;
    }

    @Override
    public SimulationFluent end(String name) {
        this.addCommand((Command)new GetVariableCommand(StatefulKnowledgeSession.class.getName()));
        this.addCommand((Command)new SetVariableCommandFromLastReturn(name));
        return this.simulationFluent;
    }

    @Override
    public SimulationFluent end() {
        return this.simulationFluent;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent set(String name) {
        this.addCommand((Command)new SetVariableCommandFromLastReturn(null, name));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent startProcess(String identifier, Map<String, Object> params) {
        this.addCommand((Command)new StartProcessCommand(identifier, params));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent startProcess(String identifier) {
        this.addCommand((Command)new StartProcessCommand(identifier));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent createProcessInstance(String identifier, Map<String, Object> params) {
        this.addCommand((Command)new CreateProcessInstanceCommand(identifier, params));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent startProcessInstance(long processId) {
        this.addCommand((Command)new StartProcessInstanceCommand(Long.valueOf(processId)));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent signalEvent(String id, Object event, long processId) {
        this.addCommand((Command)new SignalEventCommand(processId, id, event));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent signalEvent(String id, Object event) {
        this.addCommand((Command)new SignalEventCommand(id, event));
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newStep(long distanceMillis) {
        this.simulationFluent.newStep(distanceMillis);
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newStep(long distanceMillis, TimeUnit timeUnit) {
        this.simulationFluent.newStep(distanceMillis, timeUnit);
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newRelativeStep(long relativeDistance) {
        this.simulationFluent.newRelativeStep(relativeDistance);
        return this;
    }

    @Override
    public StatefulKnowledgeSessionSimFluent newRelativeStep(long relativeDistance, TimeUnit timeUnit) {
        this.simulationFluent.newRelativeStep(relativeDistance, timeUnit);
        return this;
    }
}

