/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

public class FindProcessInstancesCommand
extends AbstractHistoryLogCommand<List<ProcessInstanceLog>> {
    private static final long serialVersionUID = 8153962391271874232L;
    private final String processId;

    public FindProcessInstancesCommand() {
        this.processId = null;
    }

    public FindProcessInstancesCommand(String processId) {
        this.processId = processId;
        if (processId == null || processId.isEmpty()) {
            throw new IllegalArgumentException("The processId field must not be null or empty.");
        }
    }

    public List<ProcessInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.processId == null || this.processId.isEmpty()) {
            return this.auditLogService.findProcessInstances();
        }
        return this.auditLogService.findProcessInstances(this.processId);
    }

    public String toString() {
        if (this.processId == null || this.processId.isEmpty()) {
            return JPAAuditLogService.class.getSimpleName() + ".findProcessInstances()";
        }
        return JPAAuditLogService.class.getSimpleName() + ".findProcessInstances(" + this.processId + ")";
    }
}

